/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseDatabaseDiff
extends AbstractLiquibaseChangeLogMojo {
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultCatalogName;
    protected String referenceDefaultSchemaName;
    protected String diffChangeLogFile;
    protected boolean diffIncludeCatalog;
    protected boolean diffIncludeSchema;
    protected boolean diffIncludeTablespace;
    protected String diffTypes;
    protected String diffExcludeObjects;
    protected String diffIncludeObjects;
    private String referenceServer;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        AuthenticationInfo referenceInfo;
        if (this.referenceServer != null && (referenceInfo = this.wagonManager.getAuthenticationInfo(this.referenceServer)) != null) {
            this.referenceUsername = referenceInfo.getUserName();
            this.referencePassword = referenceInfo.getPassword();
        }
        super.execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        ResourceAccessor fileOpener;
        ClassLoader cl = null;
        try {
            cl = this.getClassLoaderIncludingProjectClasspath();
            Thread.currentThread().setContextClassLoader(cl);
            ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
            fileOpener = this.getFileOpener(artifactClassLoader);
        }
        catch (MojoExecutionException e) {
            throw new LiquibaseException("Could not create the class loader, " + (Object)((Object)e), (Throwable)e);
        }
        Database db = liquibase.getDatabase();
        Database referenceDatabase = CommandLineUtils.createDatabaseObject((ResourceAccessor)fileOpener, (String)this.referenceUrl, (String)this.referenceUsername, (String)this.referencePassword, (String)this.referenceDriver, (String)this.referenceDefaultCatalogName, (String)this.referenceDefaultSchemaName, (boolean)this.outputDefaultCatalog, (boolean)this.outputDefaultSchema, null, null, (String)this.propertyProviderClass, null, null, (String)this.databaseChangeLogTableName, (String)this.databaseChangeLogLockTableName);
        this.getLog().info((CharSequence)("Performing Diff on database " + db.toString()));
        if (this.diffExcludeObjects != null && this.diffIncludeObjects != null) {
            throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
        }
        StandardObjectChangeFilter objectChangeFilter = null;
        if (this.diffExcludeObjects != null) {
            objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.diffExcludeObjects);
        }
        if (this.diffIncludeObjects != null) {
            objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.diffIncludeObjects);
        }
        if (this.diffChangeLogFile != null) {
            try {
                DiffOutputControl diffOutputControl = new DiffOutputControl(this.diffIncludeCatalog, this.diffIncludeSchema, this.diffIncludeTablespace, null).addIncludedSchema(new CatalogAndSchema(this.referenceDefaultCatalogName, this.referenceDefaultSchemaName));
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)objectChangeFilter);
                CommandLineUtils.doDiffToChangeLog((String)this.diffChangeLogFile, (Database)referenceDatabase, (Database)db, (DiffOutputControl)diffOutputControl, (ObjectChangeFilter)objectChangeFilter, (String)StringUtils.trimToNull((String)this.diffTypes));
                if (!new File(this.diffChangeLogFile).exists()) return;
                this.getLog().info((CharSequence)("Differences written to Change Log File, " + this.diffChangeLogFile));
                return;
            }
            catch (IOException | ParserConfigurationException e) {
                throw new LiquibaseException((Throwable)e);
            }
        } else {
            CommandLineUtils.doDiff((Database)referenceDatabase, (Database)db, (String)StringUtils.trimToNull((String)this.diffTypes), null, (ObjectChangeFilter)objectChangeFilter, (PrintStream)System.out);
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "referenceDriver: " + this.referenceDriver));
        this.getLog().info((CharSequence)(indent + "referenceUrl: " + this.referenceUrl));
        this.getLog().info((CharSequence)(indent + "referenceUsername: " + this.referenceUsername));
        this.getLog().info((CharSequence)(indent + "referencePassword: " + this.referencePassword));
        this.getLog().info((CharSequence)(indent + "referenceDefaultSchema: " + this.referenceDefaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffChangeLogFile: " + this.diffChangeLogFile));
    }

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.referenceUrl == null) {
            throw new MojoFailureException("A reference database must be provided to perform a diff.");
        }
        if (this.referencePassword == null) {
            this.referencePassword = "";
        }
    }

    @Override
    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }
}

