/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.util.ISODateFormat;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseRollback
extends AbstractLiquibaseChangeLogMojo {
    protected String rollbackTag;
    protected int rollbackCount;
    protected String rollbackDate;
    protected RollbackType type;
    protected String rollbackScript;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        this.checkRequiredRollbackParameters();
    }

    protected void checkRequiredRollbackParameters() throws MojoFailureException {
        if (this.rollbackCount == -1 && this.rollbackDate == null && this.rollbackTag == null) {
            throw new MojoFailureException("One of the rollback options must be specified, please specify one of rollbackTag, rollbackCount or rollbackDate");
        }
        if (this.rollbackCount != -1 && this.rollbackCount <= 0) {
            throw new MojoFailureException("A rollback count of " + this.rollbackCount + " is meaningless, please select a value greater than 0");
        }
        String message = "Cannot specify multiple rollbackXXX options, please select only one of rollbackTag, rollbackCount, rollbackDate.";
        if (this.rollbackCount > 0) {
            if (this.rollbackDate != null || this.rollbackTag != null) {
                throw new MojoFailureException(message);
            }
            this.type = RollbackType.COUNT;
        } else if (this.rollbackDate != null) {
            if (this.rollbackTag != null || this.rollbackCount > 0) {
                throw new MojoFailureException(message);
            }
            this.type = RollbackType.DATE;
        } else if (this.rollbackTag != null) {
            if (this.rollbackCount > 0 || this.rollbackDate != null) {
                throw new MojoFailureException(message);
            }
            this.type = RollbackType.TAG;
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "rollback Count: " + this.rollbackCount));
        this.getLog().info((CharSequence)(indent + "rollback Date: " + this.rollbackDate));
        this.getLog().info((CharSequence)(indent + "rollback Tag: " + this.rollbackTag));
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        switch (this.type) {
            case COUNT: {
                liquibase.rollback(this.rollbackCount, this.rollbackScript, new Contexts(this.contexts), new LabelExpression(this.labels));
                break;
            }
            case DATE: {
                try {
                    liquibase.rollback(this.parseDate(this.rollbackDate), this.rollbackScript, new Contexts(this.contexts), new LabelExpression(this.labels));
                    break;
                }
                catch (ParseException e) {
                    String message = "Error parsing rollbackDate: " + e.getMessage();
                    throw new LiquibaseException(message, (Throwable)e);
                }
            }
            case TAG: {
                liquibase.rollback(this.rollbackTag, this.rollbackScript, new Contexts(this.contexts), new LabelExpression(this.labels));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected rollback type, " + (Object)((Object)this.type));
            }
        }
    }

    protected Date parseDate(String date) throws ParseException {
        ISODateFormat isoFormat = new ISODateFormat();
        try {
            return isoFormat.parse(date);
        }
        catch (ParseException e) {
            DateFormat format = DateFormat.getDateInstance();
            try {
                return format.parse(date);
            }
            catch (ParseException e1) {
                throw new ParseException("Date must match ISODateFormat or STANDARD platform format.\n" + e.getMessage(), 0);
            }
        }
    }

    protected static enum RollbackType {
        TAG,
        DATE,
        COUNT;

    }
}

