/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import liquibase.Liquibase;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.core.SyncHubCommand;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseSyncHubMojo
extends AbstractLiquibaseChangeLogMojo {
    protected String hubConnectionId;
    protected String hubProjectId;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        SyncHubCommand syncHub = (SyncHubCommand)CommandFactory.getInstance().getCommand("syncHub");
        syncHub.setChangeLogFile(this.changeLogFile);
        syncHub.setUrl(database.getConnection().getURL());
        syncHub.setHubConnectionId(this.hubConnectionId);
        syncHub.setHubProjectId(this.hubProjectId);
        syncHub.setDatabase(database);
        syncHub.setFailIfOnline(false);
        try {
            CommandResult result = syncHub.execute();
            if (!result.succeeded) {
                throw new LiquibaseException(result.message);
            }
        }
        catch (CommandExecutionException cee) {
            throw new LiquibaseException("Error executing syncHub", (Throwable)cee);
        }
    }
}

