/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.command.core.helpers.PreCompareCommandStep;
import liquibase.command.core.helpers.ReferenceDbUrlConnectionCommandStep;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseDatabaseDiff
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected String referenceDriver;
    @PropertyElement
    protected String referenceUrl;
    @PropertyElement
    protected String referenceUsername;
    @PropertyElement
    protected String referencePassword;
    @PropertyElement
    protected String referenceDefaultCatalogName;
    @PropertyElement
    protected String referenceDefaultSchemaName;
    @PropertyElement
    protected String diffChangeLogFile;
    @PropertyElement
    protected boolean diffIncludeCatalog;
    @PropertyElement
    protected boolean diffIncludeSchema;
    @PropertyElement
    protected boolean diffIncludeTablespace;
    @PropertyElement
    protected String diffTypes;
    @PropertyElement
    protected String changeSetAuthor;
    @PropertyElement
    protected String diffExcludeObjects;
    @PropertyElement
    protected String diffIncludeObjects;
    @PropertyElement
    protected String referenceServer;
    @PropertyElement
    protected String schemas;
    @PropertyElement
    protected String referenceSchemas;
    @PropertyElement
    protected String outputSchemas;
    @PropertyElement
    protected String outputFile;
    @PropertyElement
    protected String runOnChangeTypes;
    @PropertyElement
    protected String replaceIfExistsTypes;
    @PropertyElement
    protected boolean useOrReplaceOption;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        AuthenticationInfo referenceInfo;
        if (this.referenceServer != null && (referenceInfo = this.wagonManager.getAuthenticationInfo(this.referenceServer)) != null) {
            this.referenceUsername = referenceInfo.getUserName();
            this.referencePassword = referenceInfo.getPassword();
        }
        super.execute();
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        block18: {
            ResourceAccessor resourceAccessor;
            ClassLoader cl = null;
            try {
                cl = this.getClassLoaderIncludingProjectClasspath();
                Thread.currentThread().setContextClassLoader(cl);
                ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
                resourceAccessor = this.getResourceAccessor(artifactClassLoader);
            }
            catch (Exception e) {
                throw new LiquibaseException("Could not create the class loader, " + String.valueOf(e), (Throwable)e);
            }
            Database db = liquibase.getDatabase();
            try (Database referenceDatabase = CommandLineUtils.createDatabaseObject((ResourceAccessor)resourceAccessor, (String)this.referenceUrl, (String)this.referenceUsername, (String)this.referencePassword, (String)this.referenceDriver, (String)this.referenceDefaultCatalogName, (String)this.referenceDefaultSchemaName, (boolean)this.outputDefaultCatalog, (boolean)this.outputDefaultSchema, null, null, (String)this.propertyProviderClass, null, null, (String)this.databaseChangeLogTableName, (String)this.databaseChangeLogLockTableName);){
                ReferenceDbUrlConnectionCommandStep.logMdc((String)this.referenceUrl, (String)this.referenceUsername, (String)this.referenceDefaultSchemaName, (String)this.referenceDefaultCatalogName);
                this.getLog().info((CharSequence)("Performing Diff on database " + db.toString()));
                if (this.diffExcludeObjects != null && this.diffIncludeObjects != null) {
                    throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
                }
                StandardObjectChangeFilter objectChangeFilter = null;
                if (this.diffExcludeObjects != null) {
                    objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.diffExcludeObjects);
                }
                if (this.diffIncludeObjects != null) {
                    objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.diffIncludeObjects);
                }
                CompareControl.SchemaComparison[] schemaComparisons = this.createSchemaComparisons(db);
                if (this.diffChangeLogFile != null) {
                    try {
                        DiffOutputControl diffOutputControl = new DiffOutputControl(this.diffIncludeCatalog, this.diffIncludeSchema, this.diffIncludeTablespace, null).addIncludedSchema(new CatalogAndSchema(this.referenceDefaultCatalogName, this.referenceDefaultSchemaName));
                        diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)objectChangeFilter);
                        if (this.useOrReplaceOption) {
                            diffOutputControl.setReplaceIfExistsSet(true);
                        }
                        CommandLineUtils.doDiffToChangeLog((String)this.diffChangeLogFile, (Database)referenceDatabase, (Database)db, (String)this.changeSetAuthor, (DiffOutputControl)diffOutputControl, (ObjectChangeFilter)objectChangeFilter, (String)StringUtil.trimToNull((String)this.diffTypes), (CompareControl.SchemaComparison[])schemaComparisons, (String)this.runOnChangeTypes, (String)this.replaceIfExistsTypes);
                        if (new File(this.diffChangeLogFile).exists()) {
                            this.getLog().info((CharSequence)("Differences written to Change Log File, " + this.diffChangeLogFile));
                        }
                        break block18;
                    }
                    catch (IOException | ParserConfigurationException e) {
                        throw new LiquibaseException((Throwable)e);
                    }
                }
                PrintStream output = this.createPrintStream();
                CommandScope liquibaseCommand = new CommandScope(new String[]{"diff"});
                liquibaseCommand.setOutput((OutputStream)output);
                liquibaseCommand.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG, (Object)db);
                liquibaseCommand.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_DATABASE_ARG, (Object)referenceDatabase);
                liquibaseCommand.addArgumentValue(PreCompareCommandStep.COMPARE_CONTROL_ARG, (Object)new CompareControl(schemaComparisons, this.diffTypes));
                liquibaseCommand.addArgumentValue(PreCompareCommandStep.OBJECT_CHANGE_FILTER_ARG, (Object)objectChangeFilter);
                if (StringUtils.isEmpty((CharSequence)this.diffTypes)) {
                    liquibaseCommand.addArgumentValue(PreCompareCommandStep.SNAPSHOT_TYPES_ARG, (Object)new Class[0]);
                } else {
                    liquibaseCommand.addArgumentValue(PreCompareCommandStep.SNAPSHOT_TYPES_ARG, (Object)DiffCommandStep.parseSnapshotTypes((String[])new String[]{this.diffTypes}));
                }
                liquibaseCommand.execute();
            }
        }
    }

    private CompareControl.SchemaComparison[] createSchemaComparisons(Database database) {
        CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas((String)this.schemas, (String)this.referenceSchemas, (String)this.outputSchemas, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (String)this.referenceDefaultCatalogName, (String)this.referenceDefaultSchemaName, (Database)database);
        PreCompareCommandStep.logMdcProperties((String)this.schemas, (String)this.outputSchemas, (String)this.referenceSchemas);
        return computedSchemas.finalSchemaComparisons;
    }

    private PrintStream createPrintStream() throws LiquibaseException {
        try {
            return this.outputFile != null ? new PrintStream(this.outputFile) : System.out;
        }
        catch (FileNotFoundException fnfe) {
            throw new LiquibaseException((Throwable)fnfe);
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "referenceDriver: " + this.referenceDriver));
        this.getLog().info((CharSequence)(indent + "referenceUrl: " + this.referenceUrl));
        this.getLog().info((CharSequence)(indent + "referenceUsername: *****"));
        this.getLog().info((CharSequence)(indent + "referencePassword: *****"));
        this.getLog().info((CharSequence)(indent + "referenceDefaultSchema: " + this.referenceDefaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffChangeLogFile: " + this.diffChangeLogFile));
    }

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.referenceUrl == null) {
            throw new MojoFailureException("A reference database must be provided to perform a diff.");
        }
        if (this.referencePassword == null) {
            this.referencePassword = "";
        }
    }
}

