/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.Liquibase;
import liquibase.commandline.CommandLineUtils;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseDatabaseDiff
extends AbstractLiquibaseChangeLogMojo {
    protected String baseDriver;
    protected String baseUrl;
    protected String baseUsername;
    protected String basePassword;
    protected String baseDefaultSchemaName;
    protected String diffChangeLogFile;

    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        ClassLoader cl = null;
        try {
            cl = this.getMavenArtifactClassLoader();
        }
        catch (MojoExecutionException e) {
            throw new LiquibaseException("Could not create the class loader, " + (Object)((Object)e), (Throwable)e);
        }
        Database db = liquibase.getDatabase();
        Database baseDatabase = CommandLineUtils.createDatabaseObject((ClassLoader)cl, (String)this.baseUrl, (String)this.baseUsername, (String)this.basePassword, (String)this.baseDriver, (String)this.baseDefaultSchemaName, null);
        this.getLog().info((CharSequence)("Performing Diff on database " + db.toString()));
        if (this.diffChangeLogFile != null) {
            try {
                CommandLineUtils.doDiffToChangeLog((String)this.diffChangeLogFile, (Database)baseDatabase, (Database)db);
                this.getLog().info((CharSequence)("Differences written to Change Log File, " + this.diffChangeLogFile));
            }
            catch (IOException e) {
                throw new LiquibaseException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new LiquibaseException((Throwable)e);
            }
        } else {
            CommandLineUtils.doDiff((Database)baseDatabase, (Database)db);
        }
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "baseDriver: " + this.baseDriver));
        this.getLog().info((CharSequence)(indent + "baseUrl: " + this.baseUrl));
        this.getLog().info((CharSequence)(indent + "baseUsername: " + this.baseUsername));
        this.getLog().info((CharSequence)(indent + "basePassword: " + this.basePassword));
        this.getLog().info((CharSequence)(indent + "baseDefaultSchema: " + this.baseDefaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffChangeLogFile: " + this.diffChangeLogFile));
    }

    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.baseUrl == null) {
            throw new MojoFailureException("A base database or hibernate configuration file must be provided to perform a diff.");
        }
        if (!this.baseUrl.startsWith("hibernate:")) {
            if (this.baseUsername == null) {
                throw new MojoFailureException("The username cannot be null for the base database when not using hibernate.");
            }
            if (this.basePassword == null) {
                this.basePassword = "";
            }
        }
    }

    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }
}

