/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import liquibase.CompositeFileOpener;
import liquibase.FileOpener;
import liquibase.FileSystemFileOpener;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.MavenFileOpener;

public abstract class AbstractLiquibaseChangeLogMojo
extends AbstractLiquibaseMojo {
    protected String changeLogFile;
    protected boolean dropFirst;
    private boolean dropFirstDefault = false;
    protected String contexts;
    private String contextsDefault = "";

    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.changeLogFile == null) {
            throw new MojoFailureException("The changeLogFile must be specified.");
        }
    }

    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        if (this.dropFirst) {
            liquibase.dropAll();
        }
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "changeLogFile: " + this.changeLogFile));
        this.getLog().info((CharSequence)(indent + "drop first? " + this.dropFirst));
        this.getLog().info((CharSequence)(indent + "context(s): " + this.contexts));
    }

    protected FileOpener getFileOpener(ClassLoader cl) {
        MavenFileOpener mFO = new MavenFileOpener(cl);
        FileSystemFileOpener fsFO = new FileSystemFileOpener(this.project.getBasedir().getAbsolutePath());
        return new CompositeFileOpener(new FileOpener[]{mFO, fsFO});
    }

    protected Liquibase createLiquibase(FileOpener fo, Database db) throws MojoExecutionException {
        String changeLog = this.changeLogFile == null ? "" : this.changeLogFile.trim();
        return new Liquibase(changeLog, fo, db);
    }
}

