/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.litesoft.annotations.expectations.Expectation;
import org.litesoft.annotations.expectations.IllegalArgument;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
public @interface Positive {
    public static final String EXPECTATION = "Positive";
    public static final int ZERO_int = 0;
    public static final long ZERO_long = 0L;
    public static final float ZERO_float = 0.0f;
    public static final double ZERO_double = 0.0;

    public static class AssertArgument {
        public static int namedValue(String pName, int pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, (Expectation)IllegalArgument.INSTANCE);
        }

        public static long namedValue(String pName, long pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, (Expectation)IllegalArgument.INSTANCE);
        }

        public static float namedValue(String pName, float pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, (Expectation)IllegalArgument.INSTANCE);
        }

        public static double namedValue(String pName, double pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, (Expectation)IllegalArgument.INSTANCE);
        }
    }

    public static class Assert {
        public static int namedValueExpectation(String pName, int pToCheck, Expectation pExpectation) throws IllegalArgumentException {
            Validate.value(pName, pToCheck, pExpectation);
            return pToCheck;
        }

        public static long namedValueExpectation(String pName, long pToCheck, Expectation pExpectation) throws IllegalArgumentException {
            Validate.value(pName, pToCheck, pExpectation);
            return pToCheck;
        }

        public static float namedValueExpectation(String pName, float pToCheck, Expectation pExpectation) throws IllegalArgumentException {
            Validate.value(pName, pToCheck, pExpectation);
            return pToCheck;
        }

        public static double namedValueExpectation(String pName, double pToCheck, Expectation pExpectation) throws IllegalArgumentException {
            Validate.value(pName, pToCheck, pExpectation);
            return pToCheck;
        }
    }

    public static class Check {
        public static boolean value(int pToCheck) {
            return 0 < pToCheck;
        }

        public static boolean value(long pToCheck) {
            return 0L < pToCheck;
        }

        public static boolean value(float pToCheck) {
            return !Float.isNaN(pToCheck) && 0.0f < pToCheck;
        }

        public static boolean value(double pToCheck) {
            return !Double.isNaN(pToCheck) && 0.0 < pToCheck;
        }
    }

    public static class Validate {
        public static boolean value(String pName, int pToCheck, Expectation pExpectation) {
            return Validate.validate(Check.value(pToCheck), pName, pToCheck, pExpectation);
        }

        public static boolean value(String pName, long pToCheck, Expectation pExpectation) {
            return Validate.validate(Check.value(pToCheck), pName, pToCheck, pExpectation);
        }

        public static boolean value(String pName, float pToCheck, Expectation pExpectation) {
            return Validate.validate(Check.value(pToCheck), pName, Float.valueOf(pToCheck), pExpectation);
        }

        public static boolean value(String pName, double pToCheck, Expectation pExpectation) {
            return Validate.validate(Check.value(pToCheck), pName, pToCheck, pExpectation);
        }

        private static boolean validate(boolean pAcceptable, String pName, Object pToCheck, Expectation pExpectation) {
            if (!pAcceptable) {
                pExpectation.unmet(pName, pToCheck, Positive.EXPECTATION);
            }
            return pAcceptable;
        }
    }
}

