/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.litesoft.annotations.expectations.Expectation;
import org.litesoft.annotations.expectations.IllegalArgument;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
public @interface Significant {
    public static final String EXPECTATION = "Significant";

    public static class AssertArgument {
        public static String namedValue(String pName, String pToCheck) throws IllegalArgumentException {
            return Assert.namedValueExpectation(pName, pToCheck, IllegalArgument.INSTANCE);
        }
    }

    public static class Assert {
        public static String namedValueExpectation(String pName, String pToCheck, Expectation pExpectation) throws IllegalArgumentException {
            String zResult = ConstrainTo.valueOrNull(pToCheck);
            if (zResult == null) {
                pExpectation.unmet(pName, pToCheck, Significant.EXPECTATION);
            }
            return zResult;
        }
    }

    public static class ConstrainTo {
        public static String valueOrNull(String pToCheck) {
            return ConstrainTo.valueOr(pToCheck, null);
        }

        public static String valueOrEmpty(String pToCheck) {
            return ConstrainTo.valueOr(pToCheck, "");
        }

        public static String valueOr(String pToCheck, String pValueIfNotSignificant) {
            return pToCheck != null && !pToCheck.isBlank() ? pToCheck.trim() : pValueIfNotSignificant;
        }
    }

    public static class Check {
        public static boolean value(String pToCheck) {
            return null != ConstrainTo.valueOrNull(pToCheck);
        }
    }

    public static class Validate {
        public static boolean value(String pName, String pToCheck, Expectation pExpectation) {
            boolean zAcceptable = Check.value(pToCheck);
            if (!zAcceptable) {
                pExpectation.unmet(pName, pToCheck, Significant.EXPECTATION);
            }
            return zAcceptable;
        }
    }
}

