/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.bitstream.AbstractBitStreamSequentialSink;
import org.litesoft.bitstream.BitBuffer;
import org.litesoft.bitstream.BitStreamSequentialSink;
import org.litesoft.bitstream.Nbits;

public abstract class AbstractBitBufferStreamSequentialSink<T>
extends AbstractBitStreamSequentialSink<T> {
    protected final BitBuffer buffer = new BitBuffer();
    public final SinkBitStream<T> sinkBitStream;

    protected AbstractBitBufferStreamSequentialSink(SinkBitStream<T> sinkBitStream) {
        this.sinkBitStream = sinkBitStream;
    }

    @Override
    public final int bitsCurrentlyNeeded() {
        return this.sinkBitStream.bitsCurrentlyNeeded(this.buffer);
    }

    @Override
    public final BitStreamSequentialSink<T> addNbits(int n, int bits) {
        this.buffer.addNbits(n, Nbits.addNbits(0, this.bitsCurrentlyNeeded(), this, n, bits));
        while (this.sinkBitStream.getBitSize() <= this.buffer.availableBits()) {
            this.sinkBitStream.addBits(this.buffer.removeNbits(this.sinkBitStream.getBitSize()));
        }
        return this;
    }

    protected static abstract class SinkBitStream<T> {
        private final int bitsSize;

        public SinkBitStream(int bitsSize) {
            this.bitsSize = bitsSize;
        }

        public abstract T getValue();

        public final int getBitSize() {
            return this.bitsSize;
        }

        public abstract int bitsCurrentlyNeeded(BitBuffer var1);

        public abstract void addBits(int var1);
    }
}

