/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.annotations.PackageFriendlyForTesting;
import org.litesoft.bitstream.AbstractBitBufferStreamSequentialSource;
import org.litesoft.bitstream.AbstractBitStreamSequentialSource;

public class IntLengthSequentialSource
extends AbstractBitBufferStreamSequentialSource {
    @PackageFriendlyForTesting
    static final String LENGTH_NEGATIVE_PREFIX = "length may not be negative, but was: ";

    public IntLengthSequentialSource(int length) {
        super(new SBS(length));
    }

    static class SBS
    extends AbstractBitStreamSequentialSource.SourceBitStream {
        private final byte[] chunksOf6bit = new byte[7];
        private int populatedChunks;

        public SBS(int length) {
            super(6);
            if (length < 0) {
                throw new IllegalStateException(IntLengthSequentialSource.LENGTH_NEGATIVE_PREFIX + length);
            }
            this.chunksOf6bit[this.populatedChunks++] = (byte)(length & 0x1F);
            while ((length >>= 5) != 0) {
                this.chunksOf6bit[this.populatedChunks++] = (byte)(32 + (length & 0x1F));
            }
        }

        @Override
        public int availableBits() {
            return 6 * this.populatedChunks;
        }

        @Override
        public int removeBits() {
            return this.chunksOf6bit[--this.populatedChunks];
        }
    }
}

