/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.bitstream.BitConstants;
import org.litesoft.bitstream.BitStreamBuilder;
import org.litesoft.bitstream.BitStreamProvider;

class Nbits
implements BitConstants {
    Nbits() {
    }

    public static int addNbits(int currentBitCount, int maxBitCount, BitStreamBuilder<?> builder, int n, int bits) {
        if (n < 1 || 8 < n) {
            throw Nbits.error(builder, "add", n, " not between 1 and 8 (inclusive)");
        }
        if (currentBitCount + n > maxBitCount) {
            throw Nbits.error(builder, "add", n, " would exceed maximum allowed bits to add of " + maxBitCount + " bits");
        }
        return MASKS[n] & bits;
    }

    public static int removeNbits(int currentBitCount, BitStreamProvider provider, int n) {
        if (n < 1 || 8 < n) {
            throw Nbits.error(provider, "remove", n, " not between 1 and 8 (inclusive)");
        }
        if (currentBitCount < n) {
            throw Nbits.error(provider, "remove", n, ", but only " + currentBitCount + " are available");
        }
        return MASKS[n];
    }

    public static IllegalStateException error(Object builderOrProvider, String direction, int count, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(builderOrProvider.getClass().getSimpleName()).append(" error ").append(direction).append(count).append("bit");
        if (count > 1) {
            sb.append('s');
        }
        sb.append(message);
        throw new IllegalStateException(sb.toString());
    }
}

