/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import org.litesoft.bitstream.BitConstants;
import org.litesoft.bitstream.BitStreamBuilder;
import org.litesoft.bitstream.Nbits;

public class OnesComplimentLongBitsBuilder
implements BitStreamBuilder<OnesComplimentLongBitsBuilder>,
BitConstants {
    private boolean negative;
    private int bitCount;
    private long value;

    public OnesComplimentLongBitsBuilder negative() {
        return this.withNegative(true);
    }

    public OnesComplimentLongBitsBuilder withSignBit(int zeroMeansPositiveElseNegative) {
        return this.withNegative(0 != zeroMeansPositiveElseNegative);
    }

    public OnesComplimentLongBitsBuilder withNegative(boolean negative) {
        this.negative = negative;
        return this;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getValue() {
        if (!this.negative) {
            return this.value;
        }
        return this.value == 0L ? Long.MIN_VALUE : -this.value;
    }

    @Override
    public OnesComplimentLongBitsBuilder addNbits(int n, int bits) {
        int trialN;
        int trialBits;
        int newBitCount = this.bitCount + n;
        if (1 <= n && n <= 8 && newBitCount > 63 && (trialBits = bits & MASKS[trialN = n - (newBitCount - 63)]) == bits) {
            if (trialN == 0) {
                return this;
            }
            n = trialN;
        }
        bits = Nbits.addNbits(this.bitCount, 63, this, n, bits);
        long longBits = (long)bits << this.bitCount;
        this.value += longBits;
        this.bitCount += n;
        return this;
    }
}

