/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import java.nio.charset.StandardCharsets;
import org.litesoft.bitstream.AbstractBitBufferStreamSequentialSource;
import org.litesoft.bitstream.AbstractBitStreamSequentialSource;

public class StringSequentialSource
extends AbstractBitBufferStreamSequentialSource {
    public static byte[] utf8Bytes(String str) {
        return str == null ? new byte[]{} : str.getBytes(StandardCharsets.UTF_8);
    }

    public StringSequentialSource(String str) {
        this(StringSequentialSource.utf8Bytes(str));
    }

    public StringSequentialSource(byte[] utf8Bytes) {
        super(new SBS(utf8Bytes));
    }

    static class SBS
    extends AbstractBitStreamSequentialSource.SourceBitStream {
        private final byte[] utf8Bytes;
        private int byteOffset;

        public SBS(byte[] utf8Bytes) {
            super(8);
            this.utf8Bytes = utf8Bytes;
        }

        @Override
        public int availableBits() {
            return 8 * (this.utf8Bytes.length - this.byteOffset);
        }

        @Override
        public int removeBits() {
            return this.utf8Bytes[this.byteOffset++];
        }
    }
}

