/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import java.util.UUID;
import org.litesoft.annotations.NotNull;
import org.litesoft.bitstream.AbstractBitBufferStreamSequentialSink;
import org.litesoft.bitstream.BitBuffer;
import org.litesoft.bitstream.BitConstants;
import org.litesoft.utils.Hex;
import org.litesoft.utils.UuidNonDashCharOffsets;

public class UuidSequentialSink
extends AbstractBitBufferStreamSequentialSink<UUID> {
    public UuidSequentialSink() {
        super(new SBS());
    }

    @Override
    @NotNull
    public UUID getValue() {
        return (UUID)this.sinkBitStream.getValue();
    }

    static class SBS
    extends AbstractBitBufferStreamSequentialSink.SinkBitStream<UUID>
    implements BitConstants {
        private final StringBuilder value = new StringBuilder();
        private int lastOffset = -1;
        private int hexDigitsIndex;
        private boolean full;

        SBS() {
            super(4);
        }

        @Override
        public UUID getValue() {
            if (!this.full) {
                throw new IllegalStateException("Stream error value not fully populated");
            }
            return UUID.fromString(this.value.toString());
        }

        @Override
        public int bitsCurrentlyNeeded(BitBuffer buffer) {
            return this.full ? 0 : 4 - buffer.availableBits();
        }

        @Override
        public void addBits(int bits) {
            int offset;
            if (++this.lastOffset != (offset = UuidNonDashCharOffsets.HEX_DIGIT_OFFSETS[this.hexDigitsIndex++])) {
                this.value.append('-');
                this.lastOffset = offset;
            }
            this.value.append(Hex.charFrom((int)bits));
            this.full = this.hexDigitsIndex >= UuidNonDashCharOffsets.HEX_DIGIT_OFFSETS.length;
        }
    }
}

