/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.bitstream;

import java.util.UUID;
import org.litesoft.annotations.NotNull;
import org.litesoft.bitstream.AbstractBitBufferStreamSequentialSource;
import org.litesoft.bitstream.AbstractBitStreamSequentialSource;
import org.litesoft.utils.Hex;
import org.litesoft.utils.UuidNonDashCharOffsets;

public class UuidSequentialSource
extends AbstractBitBufferStreamSequentialSource {
    public UuidSequentialSource(@NotNull UUID uuid) {
        super(new SBS(((UUID)NotNull.AssertArgument.namedValue((String)"uuid", (Object)uuid)).toString()));
    }

    static class SBS
    extends AbstractBitStreamSequentialSource.SourceBitStream {
        private final String uuid;
        private int nibleOffset;

        public SBS(String uuid) {
            super(4);
            this.uuid = uuid;
        }

        @Override
        public int availableBits() {
            return 4 * (UuidNonDashCharOffsets.HEX_DIGIT_OFFSETS.length - this.nibleOffset);
        }

        @Override
        public int removeBits() {
            return Hex.from((char)this.uuid.charAt(UuidNonDashCharOffsets.HEX_DIGIT_OFFSETS[this.nibleOffset++]));
        }
    }
}

