/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.codec;

public class Base64urlCodec6bitInts {
    public static final int MASK = 63;
    public static final String BAD_CHARACTER_PREFIX = "Character '";
    public static final String BAD_CHARACTER_SUFFIX = "' not valid for base64url(s)";

    public char encode(int bits6) {
        if ((bits6 &= 0x3F) < 26) {
            return Base64urlCodec6bitInts.toChar('A', 0, bits6);
        }
        if (bits6 < 52) {
            return Base64urlCodec6bitInts.toChar('a', 26, bits6);
        }
        if (bits6 < 62) {
            return Base64urlCodec6bitInts.toChar('0', 52, bits6);
        }
        return bits6 == 62 ? (char)'-' : '_';
    }

    public int decode(char c) throws IllegalArgumentException {
        if (Base64urlCodec6bitInts.isCharBetween(c, 'A', 'Z')) {
            return Base64urlCodec6bitInts.toInt('A', 0, c);
        }
        if (Base64urlCodec6bitInts.isCharBetween(c, 'a', 'z')) {
            return Base64urlCodec6bitInts.toInt('a', 26, c);
        }
        if (Base64urlCodec6bitInts.isCharBetween(c, '0', '9')) {
            return Base64urlCodec6bitInts.toInt('0', 52, c);
        }
        if (c == '-') {
            return 62;
        }
        if (c == '_') {
            return 63;
        }
        throw new IllegalArgumentException(BAD_CHARACTER_PREFIX + c + BAD_CHARACTER_SUFFIX);
    }

    private static boolean isCharBetween(char c, char lowInclusive, char highInclusive) {
        return lowInclusive <= c && c <= highInclusive;
    }

    private static char toChar(char rangeBaseChar, int offset, int bits6) {
        return (char)(rangeBaseChar + (bits6 - offset));
    }

    private static int toInt(char rangeBaseChar, int offset, char sourceChar) {
        return offset + (sourceChar - rangeBaseChar);
    }
}

