/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.codec;

import java.util.HashMap;
import java.util.Map;
import org.litesoft.annotations.PackageFriendlyForTesting;
import org.litesoft.annotations.Significant;

public class Codec {
    private static final Map<String, Class<? extends Codec>> REGISTERED = new HashMap<String, Class<? extends Codec>>();
    protected final String codecId;
    @PackageFriendlyForTesting
    static final String ERROR_DUPLICATE_REGISTRATION_MID_TEXT = " -- duplicate registration attempted, classes are:";
    static final String ERROR_CODEX_ID_PART_CONTAINED_COLON_SUFFIX = " must NOT contain a ':' colon (reserved for Codec Id terminating character)";
    static final String ERROR_CODEX_ID_PART_INSIGNIFICANT_SUFFIX = " must NOT be null or empty";
    static final String ERROR_CODEX_ID_PART_NOT_POSITIVE_SUFFIX = " MUST be positive (1 or greater)";

    protected Codec(String codecGroup, String codecSpecialization, int codecVersion) {
        this.codecId = this.assertIdPart("codecGroup", codecGroup) + this.assertIdPart("codecSpecialization", codecSpecialization) + this.assertIdPart("codecVersion", codecVersion) + ":";
        Class<?> us = this.getClass();
        Class<?> previous = REGISTERED.put(this.codecId, us);
        if (previous != null && previous != us) {
            throw new Error("CodecId '" + this.codecId + "' -- duplicate registration attempted, classes are:\n    " + previous + "\n    " + us);
        }
    }

    private String assertIdPart(String name, String value) {
        if (value.contains(":")) {
            throw new Error("Codec Id part '" + name + "' must NOT contain a ':' colon (reserved for Codec Id terminating character)");
        }
        if ((value = Significant.ConstrainTo.valueOrNull((String)value)) == null) {
            throw new Error("Codec Id part '" + name + "' must NOT be null or empty");
        }
        return value;
    }

    private int assertIdPart(String name, int value) {
        if (value < 1) {
            throw new Error("Codec Id part '" + name + "' MUST be positive (1 or greater)");
        }
        return value;
    }

    protected String validateToEncode(String toEncode, int minLength) {
        if ((toEncode = Significant.AssertArgument.namedValue((String)"to encode", (String)toEncode)).length() < minLength) {
            throw new IllegalArgumentException(this.errorToEncodeTooShort(minLength) + toEncode);
        }
        return toEncode;
    }

    protected String validateToDecode(String encoded) {
        if (!(encoded = Significant.AssertArgument.namedValue((String)"encoded", (String)encoded)).startsWith(this.codecId)) {
            throw new IllegalArgumentException(this.errorDidNotStartWithCodecId() + Codec.limitLength(encoded));
        }
        if (encoded.equals(this.codecId)) {
            throw new IllegalArgumentException(this.errorOnlyCodecId());
        }
        return encoded.substring(this.codecId.length());
    }

    private static String limitLength(String value) {
        return value.length() <= 20 ? value : value.substring(0, 17) + "...";
    }

    @PackageFriendlyForTesting
    String errorDidNotStartWithCodecId() {
        return "supplied encoded string did NOT start with '" + this.codecId + "', encoded string was: ";
    }

    @PackageFriendlyForTesting
    String errorOnlyCodecId() {
        return "supplied encoded string consisted ONLY of '" + this.codecId + "'";
    }

    @PackageFriendlyForTesting
    String errorToEncodeTooShort(int minLength) {
        return "supplied string to class '" + this.getClass().getSimpleName() + "' to encode MUST be at least " + minLength + " characters long, the string was: ";
    }

    @PackageFriendlyForTesting
    static void clearRegistration() {
        REGISTERED.clear();
    }
}

