/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.fields;

import java.util.function.Consumer;
import java.util.function.Function;
import org.litesoft.exceptions.ExceededMaxLengthException;
import org.litesoft.fields.AccessorType;
import org.litesoft.fields.MutableAccessor;
import org.litesoft.fields.RequiredFieldInsignificantException;
import org.litesoft.utils.Cast;

public class Accessor<T, R>
implements Function<T, R> {
    private final AccessorType accessorType;
    private final String name;
    private final Function<T, R> accessor;
    private String metaData;
    private Class<? extends R> type;
    private String typeWithOptionalSize = "";
    private Integer maxLength;
    private Consumer<? extends R> validator;

    public static <T, R> Accessor<T, R> of(AccessorType accessorType, String name, Function<T, R> accessor) {
        return new Accessor<T, R>(accessorType, name, accessor);
    }

    protected Accessor(AccessorType accessorType, String name, Function<T, R> accessor) {
        this.accessorType = accessorType;
        this.name = name;
        this.metaData = accessorType.initialMetaData();
        this.accessor = accessor;
    }

    public MutableAccessor<T, R> asMutable() {
        return this instanceof MutableAccessor ? (MutableAccessor)this : null;
    }

    public AccessorType getAccessorType() {
        return this.accessorType;
    }

    public boolean isMutable() {
        return null != this.asMutable();
    }

    public String getName() {
        return this.name;
    }

    public R getValue(T instance) {
        return this.accessor.apply(instance);
    }

    public void validate(T instance) {
        int actualLength;
        R value = this.normalize(instance, this.getValue(instance));
        if (value == null) {
            if (this.getAccessorType() == AccessorType.required) {
                throw new RequiredFieldInsignificantException();
            }
            return;
        }
        if (this.validator != null) {
            this.validator.accept(Cast.it(value));
        }
        if (this.maxLength != null && (actualLength = Accessor.typeToLength(value)) > this.maxLength) {
            throw new ExceededMaxLengthException(this.maxLength, actualLength);
        }
    }

    @Override
    public R apply(T instance) {
        return this.getValue(instance);
    }

    public String getMetaData() {
        return this.metaData;
    }

    public Class<? extends R> getType() {
        return this.type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "('" + this.name + "')";
    }

    public String description() {
        return this.description(new StringBuilder(), null, null).toString();
    }

    public int getNameLengthForDescription() {
        return this.getName().length();
    }

    public int getTypeLengthForDescription() {
        return this.typeWithOptionalSize.length();
    }

    public StringBuilder description(StringBuilder sb, Integer padNameToAtLeast, Integer padTypeToAtLeast) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        int relativeZero = sb.length();
        sb.append(this.name);
        String metaData = this.getMetaData();
        if (!this.typeWithOptionalSize.isEmpty() || !metaData.isEmpty()) {
            Accessor.padTo(sb, relativeZero + padNameToAtLeast);
            sb.append(' ');
            relativeZero = sb.length();
            sb.append(this.typeWithOptionalSize);
            if (!metaData.isEmpty()) {
                if (padTypeToAtLeast != null) {
                    Accessor.padTo(sb, relativeZero + padTypeToAtLeast);
                }
                sb.append(" (").append(metaData).append(')');
            }
        }
        return sb;
    }

    public <TR extends R> Accessor<T, R> withType(Class<TR> type, Consumer<TR> validator) {
        this.withType(type);
        this.validator = validator;
        return this;
    }

    public Accessor<T, R> withType(Class<? extends R> type) {
        this.type = type;
        this.populateTypeWithOptionalSize();
        return this;
    }

    public Accessor<T, R> addMaxLength(int maxLength) {
        if (maxLength < 1) {
            throw new Error("coding error, max length must be at least 1");
        }
        this.maxLength = maxLength;
        this.populateTypeWithOptionalSize();
        return this;
    }

    public Accessor<T, R> addMetaData(String additionalMetaData) {
        String string = additionalMetaData = additionalMetaData == null ? "" : additionalMetaData.trim();
        if (!additionalMetaData.isEmpty()) {
            this.metaData = this.metaData.isEmpty() ? additionalMetaData : this.metaData + " & " + additionalMetaData;
        }
        return this;
    }

    public Accessor<T, R> withMetaData(String metaData) {
        this.metaData = metaData == null ? "" : metaData.trim();
        return this;
    }

    protected R normalize(T instance, R value) {
        return value;
    }

    private void populateTypeWithOptionalSize() {
        Class<R> type = this.getType();
        String string = this.typeWithOptionalSize = type == null ? "" : type.getSimpleName();
        if (this.maxLength != null) {
            this.typeWithOptionalSize = this.typeWithOptionalSize + "(" + this.maxLength + ")";
        }
    }

    private static void padTo(StringBuilder sb, Integer toAtLeast) {
        if (toAtLeast != null) {
            while (sb.length() < toAtLeast) {
                sb.append(' ');
            }
        }
    }

    private static int typeToLength(Object o) {
        if (o != null && o instanceof String) {
            return ((String)o).length();
        }
        return Integer.MIN_VALUE;
    }
}

