/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.fields;

import java.util.Arrays;
import org.litesoft.annotations.NotNull;
import org.litesoft.annotations.Significant;
import org.litesoft.utils.TemplatedMessage;

public class FieldError {
    private final String fieldName;
    private final TemplatedMessage templatedMessage;

    public FieldError(String fieldName, TemplatedMessage templatedMessage) {
        this.fieldName = Significant.AssertArgument.namedValue((String)"fieldName", (String)fieldName);
        this.templatedMessage = (TemplatedMessage)NotNull.AssertArgument.namedValue((String)"templatedMessage", (Object)templatedMessage);
    }

    public FieldError(String fieldName, String fmtString, String ... indexedFmtData) {
        this(fieldName, new TemplatedMessage(fmtString, indexedFmtData));
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFmtString() {
        return this.templatedMessage.getFmtString();
    }

    public String[] getIndexedFmtData() {
        return this.templatedMessage.getIndexedFmtData();
    }

    public FieldError replaceFmtString(String fmtString) {
        this.templatedMessage.replaceFmtString(fmtString);
        return this;
    }

    public FieldError replaceIndexedFmtData(String ... indexedFmtData) {
        this.templatedMessage.replaceIndexedFmtData(indexedFmtData);
        return this;
    }

    public String errorMsg() {
        return this.templatedMessage.toString();
    }

    public String toString() {
        return "FieldError{fieldName='" + this.fieldName + "', fmtString='" + this.getFmtString() + "', indexedFmtData=" + Arrays.toString(this.getIndexedFmtData()) + "}";
    }
}

