/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid;

import java.util.UUID;
import org.litesoft.utils.Hex;

public class UuidMoniker {
    private final String uuid;
    private final StringBuilder sb = new StringBuilder();
    private final boolean[] used = new boolean[16];
    private final int[] bytes = new int[16];
    private int index = 0;
    private static final AlphabetMapper IDENTITY = c -> c;
    private static final AlphabetMapper GAP_UPPER_LOWER = UuidMoniker.mapper(91, 96);
    private static final AlphabetMapper GAP_BEYOND_LOWER = UuidMoniker.mapper(123, 127);
    private static final AlphabetMapper GAP_LOW_CHUNK_1 = UuidMoniker.mapper(0, 25);
    private static final AlphabetMapper GAP_LOW_CHUNK_2 = UuidMoniker.mapper(20, 45);
    private static final AlphabetMapper GAP_LOW_CHUNK_3 = UuidMoniker.mapper(39, 64);
    private static final String CONSONANTS = "bcdfghjklmnprstvwxyz";
    private static final String VOWELS = "aeiou";

    public static String from(UUID uuid) {
        return uuid == null ? null : new UuidMoniker(uuid.toString()).unpack().toMoniker();
    }

    private UuidMoniker(String uuid) {
        this.uuid = uuid;
    }

    private UuidMoniker unpack() {
        this.addSection(0, 8);
        this.addSection(9, 4);
        this.addSection(14, 4);
        this.addSection(19, 4);
        this.addSection(24, 12);
        return this;
    }

    private void addSection(int from, int length) {
        int uptoExclusive = from + length;
        while (from < uptoExclusive) {
            char c1 = this.uuid.charAt(from++);
            char c2 = this.uuid.charAt(from++);
            this.addAscii(0x7F & Hex.from((char)c1, (char)c2));
        }
    }

    private void addAscii(int c) {
        this.bytes[this.index++] = c;
    }

    public String toString() {
        return this.uuid + " --> " + this.sb;
    }

    private String toMoniker() {
        this.addConsonant(Character::toUpperCase);
        this.addVowel(Character::toLowerCase);
        this.addConsonant(Character::toLowerCase);
        this.addVowel(Character::toLowerCase);
        this.addConsonant(Character::toLowerCase);
        return this.sb.append('-').append(this.bytes[15]).toString();
    }

    private static AlphabetMapper mapper(int from, int thru) {
        return c -> from <= c && c <= thru ? (int)(c + 65) : c;
    }

    private void addConsonant(CharCaseTransformer mCase) {
        this.addCharacter(mCase, UuidMoniker::isConsonant, CONSONANTS);
    }

    private void addVowel(CharCaseTransformer mCase) {
        this.addCharacter(mCase, UuidMoniker::isVowel, VOWELS);
    }

    private void addCharacter(CharCaseTransformer mCase, CharFilter charFilter, String fallbackChars) {
        if (!this.selectFromAlphabetMapper(mCase, charFilter, IDENTITY, GAP_UPPER_LOWER, GAP_BEYOND_LOWER, GAP_LOW_CHUNK_1, GAP_LOW_CHUNK_2, GAP_LOW_CHUNK_3)) {
            this.selectFromFallback(mCase, fallbackChars);
        }
    }

    private void selectFromFallback(CharCaseTransformer caseTransformer, String fallbackChars) {
        for (int i = 0; i < this.bytes.length; ++i) {
            int value;
            if (this.used[i]) continue;
            for (value = this.bytes[i]; fallbackChars.length() <= value; value /= 2) {
            }
            this.addToOutput(i, caseTransformer.transform(fallbackChars.charAt(value)));
            return;
        }
    }

    private boolean selectFromAlphabetMapper(CharCaseTransformer caseTransformer, CharFilter charFilter, AlphabetMapper ... mappers) {
        for (AlphabetMapper mapper : mappers) {
            for (int i = 0; i < this.bytes.length; ++i) {
                int c;
                if (this.used[i] || !charFilter.accept(c = mapper.map(this.bytes[i]))) continue;
                this.addToOutput(i, caseTransformer.transform(c));
                return true;
            }
        }
        return false;
    }

    private void addToOutput(int index, int c) {
        this.sb.append((char)c);
        this.used[index] = true;
    }

    private static boolean isConsonant(int c) {
        return UuidMoniker.isLetter(c) && !UuidMoniker.isVowel(c);
    }

    private static boolean isVowel(int c) {
        return UuidMoniker.isEther(c, 65, 97) || UuidMoniker.isEther(c, 69, 101) || UuidMoniker.isEther(c, 73, 105) || UuidMoniker.isEther(c, 79, 111) || UuidMoniker.isEther(c, 85, 117);
    }

    private static boolean isEther(int c, int uc, int lc) {
        return c == uc || c == lc;
    }

    private static boolean isLetter(int c) {
        return (65 <= c && c <= 90 || 97 <= c && c <= 122) && c != 81 && c != 113 && c != 88 && c != 120;
    }

    static interface CharCaseTransformer {
        public int transform(int var1);
    }

    static interface AlphabetMapper {
        public int map(int var1);
    }

    static interface CharFilter {
        public boolean accept(int var1);
    }
}

