/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.litesoft.annotations.NotNull;

public final class UuidStringsPair {
    private final UUID uuid;
    private final List<String> strings;

    public static UuidStringsPair of(@NotNull UUID uuid, List<String> strings) {
        return new UuidStringsPair(uuid, strings == null ? Collections.emptyList() : List.copyOf(strings));
    }

    public static UuidStringsPair of(@NotNull UUID uuid, String ... strings) {
        return new UuidStringsPair(uuid, strings == null ? Collections.emptyList() : Arrays.asList(strings));
    }

    private UuidStringsPair(UUID uuid, List<String> strings) {
        this.uuid = (UUID)NotNull.AssertArgument.namedValue((String)"uuid", (Object)uuid);
        this.strings = strings;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public List<String> getStrings() {
        return this.strings;
    }

    public String toString() {
        return "UuidVersionPair{uuid=" + this.getUuid() + ", strings=" + this.getStrings() + "}";
    }

    public boolean equals(UuidStringsPair them) {
        return this == them || them != null && this.strings.equals(them.strings) && this.uuid.equals(them.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object them) {
        return this == them || this.getClass() == them.getClass() && this.equals((UuidStringsPair)them);
    }
}

