/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid;

import java.util.Objects;
import java.util.UUID;
import org.litesoft.annotations.NotNull;

public final class UuidVersionPair {
    private final UUID uuid;
    private final long version;

    public static UuidVersionPair of(UUID uuid, long version) {
        return new UuidVersionPair(uuid, version);
    }

    private UuidVersionPair(UUID uuid, long version) {
        this.uuid = (UUID)NotNull.AssertArgument.namedValue((String)"uuid", (Object)uuid);
        this.version = version;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return "UuidVersionPair{uuid=" + this.getUuid() + ", version=" + this.getVersion() + "}";
    }

    public boolean equals(UuidVersionPair them) {
        return this == them || them != null && this.version == them.version && this.uuid.equals(them.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.version);
    }

    public boolean equals(Object them) {
        return this == them || this.getClass() == them.getClass() && this.equals((UuidVersionPair)them);
    }
}

