/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import org.litesoft.bitstream.BitBuffer;
import org.litesoft.bitstream.BitStreamBuilder;
import org.litesoft.bitstream.BitStreamProvider;
import org.litesoft.bitstream.BitStreamSequentialSink;
import org.litesoft.bitstream.IntLengthSequentialSink;
import org.litesoft.bitstream.StringSequentialSink;
import org.litesoft.codec.Base64urlCodec6bitInts;
import org.litesoft.codec.morphers.Morph6bitInts;
import org.litesoft.utils.Cast;
import org.litesoft.uuid.codecsupport.AsciiStringStream;

public abstract class BaseCodecSupport {
    protected static final Base64urlCodec6bitInts codec = new Base64urlCodec6bitInts();

    protected static abstract class AbstractDecodeStream
    implements BitStreamProvider {
        private final Morph6bitInts morpher = new Morph6bitInts();
        private final BitBuffer buffer = new BitBuffer();
        private final AsciiStringStream encoded;

        public AbstractDecodeStream(String encoded) {
            this.encoded = new AsciiStringStream(encoded);
        }

        public int availableBits() {
            return this.buffer.availableBits() + 6 * this.encoded.remainingChars();
        }

        public String populateLengthString(String what) {
            int utf8Bytes = (Integer)this.populate(new IntLengthSequentialSink(), what + "(utf8Byte count)");
            return utf8Bytes == 0 ? "" : (String)this.populate(StringSequentialSink.ofBytes((int)utf8Bytes), what + "(String)");
        }

        public <T, BS extends BitStreamSequentialSink<T>> T populate(BS sink, String what) {
            int bitsNeeded = sink.bitsCurrentlyNeeded();
            while (bitsNeeded != 0) {
                sink.addNbits(bitsNeeded, this.requiredNbits(bitsNeeded, what));
                bitsNeeded = sink.bitsCurrentlyNeeded();
            }
            return (T)sink.getValue();
        }

        public void ensureStreamEmpty() {
            if (this.availableBits() > 0) {
                throw new IllegalStateException("decode Stream expected to be empty, but still " + this.availableBits() + " bits remaining");
            }
        }

        public void consumeRemainingExceptNbits(int n) {
            int nPlus = n + 8;
            while (this.availableBits() > nPlus) {
                this.remove8bits();
            }
            int nToRemove = this.availableBits() - n;
            if (nToRemove > 0) {
                this.removeNbits(nToRemove);
            }
        }

        public int required1bit(String what) {
            return this.requiredNbits(1, what);
        }

        public int required2bits(String what) {
            return this.requiredNbits(2, what);
        }

        public int required3bits(String what) {
            return this.requiredNbits(3, what);
        }

        public int required4bits(String what) {
            return this.requiredNbits(4, what);
        }

        public int required5bits(String what) {
            return this.requiredNbits(5, what);
        }

        public int required6bits(String what) {
            return this.requiredNbits(6, what);
        }

        public int required7bits(String what) {
            return this.requiredNbits(7, what);
        }

        public int required8bits(String what) {
            return this.requiredNbits(8, what);
        }

        public int requiredNbits(int n, String what) {
            return this.requireBits(n, what).removeNbits(n);
        }

        public int removeNbits(int n) {
            return this.requiredNbits(n, "remove... called");
        }

        private BitBuffer requireBits(int count, String what) {
            if (this.ensureBits(count)) {
                return this.buffer;
            }
            throw new IllegalStateException("Insufficient characters for " + what);
        }

        private boolean ensureBits(int count) {
            while (this.buffer.availableBits() < count) {
                if (!this.encoded.hasChars()) {
                    return false;
                }
                this.buffer.add6bits(this.morph6bits(codec.decode(this.encoded.nextChar())));
            }
            return true;
        }

        protected int morph6bits(int bits) {
            return this.morpher.fromMorphed(bits);
        }
    }

    protected static abstract class AbstractEncodeCollector<T extends AbstractEncodeCollector<T>>
    implements BitStreamBuilder<T> {
        protected final StringBuilder output = new StringBuilder();
        protected final Morph6bitInts morpher = new Morph6bitInts();
        protected final BitBuffer buffer = new BitBuffer();
        protected int addedBits;

        protected AbstractEncodeCollector() {
        }

        public final T addNbits(int n, int bits) {
            this.addedBits += n;
            this.buffer.addNbits(n, bits);
            while (6 <= this.buffer.availableBits()) {
                this.output.append(codec.encode(this.morph6bits(this.buffer.remove6bits())));
            }
            return (T)((AbstractEncodeCollector)Cast.it((Object)this));
        }

        public String result() {
            this.flushBuffer();
            return this.output.toString();
        }

        protected int morph6bits(int bits) {
            return this.morpher.toMorphed(bits);
        }

        protected final void flushBuffer() {
            while (this.buffer.availableBits() > 0) {
                this.add1bit(0);
            }
        }

        protected final void enforceMinimumBits(int minimumBits) {
            while (2 <= minimumBits - this.addedBits) {
                this.add2bits(1);
            }
            if (minimumBits > this.addedBits) {
                this.add1bit(1);
            }
        }
    }
}

