/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.UUID;
import java.util.function.IntSupplier;
import org.litesoft.uuid.codecsupport.UuidMorphingCodecSupport;

public abstract class K1_CodecSupport
extends UuidMorphingCodecSupport {
    private static final int FIRST_FOUR_BITS_MASK = 15;
    private static final int FINAL_6_BITS_1_OF_2 = 1;
    private static final int FINAL_6_BITS_2_OF_2 = 62;
    private static final int META_DATA_OVERHEAD = 20;

    protected static class K_DecodeStream
    extends UuidMorphingCodecSupport.AbstractUuidDecodeStream {
        private final int payloadLength;

        protected K_DecodeStream(UUID keyUUID, String encoded) {
            super(encoded, keyUUID.toString(), 1, 62);
            this.required4bits("seed");
            int payloadSizeHint = this.required4bits("payload size hint");
            this.payloadLength = payloadSizeHint != 0 ? payloadSizeHint : (encoded.length() * 6 - 20) / 8;
        }

        public int getPayloadLength() {
            return this.payloadLength;
        }
    }

    protected static class EncodeCollector
    extends UuidMorphingCodecSupport.AbstractUuidEncodeCollector<EncodeCollector> {
        protected EncodeCollector(UUID keyUUID, IntSupplier randomizingSeedSupplier, int toEncodeByteLength) {
            super(keyUUID.toString(), 1, 62);
            this.add4bits(randomizingSeedSupplier.getAsInt() & 0xF);
            this.add4bits(16 <= toEncodeByteLength + 1 ? 0 : toEncodeByteLength);
        }
    }
}

