/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.litesoft.annotations.NotEmpty;
import org.litesoft.annotations.NotNull;
import org.litesoft.uuid.codecsupport.K1_CodecSupport;

public class K1_DecodeSupport
extends K1_CodecSupport {
    private final DecodeStream ds;

    public K1_DecodeSupport(@NotNull UUID keyUUID, @NotEmpty String encoded) {
        this.ds = new DecodeStream(keyUUID, encoded);
    }

    public String decode() {
        this.ds.populatePayloadBytes();
        this.ds.consumePaddingAndCheckTailBits();
        return this.ds.results();
    }

    private static class DecodeStream
    extends K1_CodecSupport.K_DecodeStream {
        private final byte[] collector = new byte[this.getPayloadLength()];

        public DecodeStream(UUID keyUUID, String encoded) {
            super(keyUUID, encoded);
        }

        public void populatePayloadBytes() {
            for (int i = 0; i < this.collector.length; ++i) {
                this.collector[i] = (byte)this.required8bits("payload");
            }
        }

        public String results() {
            this.ensureStreamEmpty();
            return new String(this.collector, StandardCharsets.UTF_8);
        }
    }
}

