/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.litesoft.annotations.NotEmpty;
import org.litesoft.annotations.NotNull;
import org.litesoft.uuid.codecsupport.K2_CodecSupport;

public class K2_DecodeSupport
extends K2_CodecSupport {
    private final DecodeStream ds;

    public K2_DecodeSupport(@NotNull UUID keyUUID, @NotEmpty String encoded) {
        this.ds = new DecodeStream(keyUUID, encoded);
    }

    public List<String> decode() {
        this.ds.populatePayloads();
        this.ds.consumePaddingAndCheckTailBits();
        return this.ds.results();
    }

    private static class DecodeStream
    extends K2_CodecSupport.K_DecodeStream {
        private final List<String> payloads = new ArrayList<String>(this.getStrings());

        public DecodeStream(UUID keyUUID, String encoded) {
            super(keyUUID, encoded);
        }

        public void populatePayloads() {
            int i = 0;
            while (i++ < this.getStrings()) {
                this.payloads.add(this.populateLengthString("String" + i));
            }
        }

        public List<String> results() {
            this.ensureStreamEmpty();
            return this.payloads;
        }
    }
}

