/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.litesoft.annotations.NotEmpty;
import org.litesoft.annotations.NotNull;
import org.litesoft.bitstream.UuidSequentialSink;
import org.litesoft.uuid.codecsupport.K3_CodecSupport;

public class K3_DecodeSupport
extends K3_CodecSupport {
    private final DecodeStream ds;

    public K3_DecodeSupport(@NotNull UUID keyUUID, @NotEmpty String encoded) {
        this.ds = new DecodeStream(keyUUID, encoded);
    }

    public Pair decode() {
        this.ds.populatePayloads();
        this.ds.consumePaddingAndCheckTailBits();
        return this.ds.results();
    }

    private static class DecodeStream
    extends K3_CodecSupport.K_DecodeStream {
        private final List<String> strings = new ArrayList<String>(this.getStrings());
        private UUID uuid;

        public DecodeStream(UUID keyUUID, String encoded) {
            super(keyUUID, encoded);
        }

        public void populatePayloads() {
            this.uuid = (UUID)this.populate(new UuidSequentialSink(), "uuid");
            int i = 0;
            while (i++ < this.getStrings()) {
                this.strings.add(this.populateLengthString("String" + i));
            }
        }

        public Pair results() {
            this.ensureStreamEmpty();
            return new Pair(this.uuid, this.strings);
        }
    }

    public record Pair(UUID uuid, List<String> strings) {
    }
}

