/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.IntSupplier;
import org.litesoft.annotations.NotNull;
import org.litesoft.bitstream.BitStreamSequentialSource;
import org.litesoft.bitstream.UuidSequentialSource;
import org.litesoft.uuid.codecsupport.K3_CodecSupport;

public class K3_EncodeSupport
extends K3_CodecSupport {
    protected final List<BitStreamSequentialSource> parts = new ArrayList<BitStreamSequentialSource>();
    private final K3_CodecSupport.EncodeCollector collector;

    public K3_EncodeSupport(@NotNull IntSupplier randomizingSeedSupplier, @NotNull UUID keyUUID, @NotNull UUID uuid, String ... optionalStringsToEncode) {
        this.parts.add((BitStreamSequentialSource)new UuidSequentialSource(uuid));
        if (optionalStringsToEncode != null && optionalStringsToEncode.length > 0) {
            this.addStringsToParts(this.parts, optionalStringsToEncode);
        }
        this.collector = new K3_CodecSupport.EncodeCollector(keyUUID, randomizingSeedSupplier, this.parts.size() - 1);
    }

    public String encode() {
        return this.commonEncode(this.parts, this.collector).result();
    }
}

