/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.List;
import org.litesoft.bitstream.BitStreamBuilder;
import org.litesoft.bitstream.BitStreamSequentialSource;
import org.litesoft.bitstream.IntLengthSequentialSource;
import org.litesoft.bitstream.StringSequentialSource;
import org.litesoft.uuid.codecsupport.UuidMorphingCodecSupport;

public abstract class K_CodecSupportWithSequentials
extends UuidMorphingCodecSupport {
    protected void addStringsToParts(List<BitStreamSequentialSource> parts, String ... toEncode) {
        if (toEncode == null || toEncode.length == 0) {
            throw new IllegalStateException("At least one String ...");
        }
        if (toEncode.length > 16) {
            throw new IllegalStateException("No more that 16 Strings ...");
        }
        for (String str : toEncode) {
            byte[] utf8Bytes = StringSequentialSource.utf8Bytes((String)str);
            IntLengthSequentialSource src = new IntLengthSequentialSource(utf8Bytes.length);
            if (utf8Bytes.length > 0) {
                src = src.plus((BitStreamSequentialSource)new StringSequentialSource(utf8Bytes));
            }
            parts.add((BitStreamSequentialSource)src);
        }
    }

    protected <T extends BitStreamBuilder<?>> T commonEncode(List<BitStreamSequentialSource> parts, T collector) {
        for (BitStreamSequentialSource src : parts) {
            int availableBits;
            for (availableBits = src.availableBits(); availableBits > 8; availableBits -= 8) {
                collector.add8bits(src.remove8bits());
            }
            collector.addNbits(availableBits, src.removeNbits(availableBits));
        }
        return collector;
    }
}

