/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import org.litesoft.bitstream.BitBuffer;
import org.litesoft.utils.Hex;
import org.litesoft.utils.UuidNonDashCharOffsets;
import org.litesoft.uuid.codecsupport.BaseCodecSupport;
import org.litesoft.uuid.codecsupport.CodecSupportUUID;

public abstract class UuidMorphingCodecSupport
extends CodecSupportUUID {
    public static final int UUID_BYTE_LENGTH = 16;
    private static final int MINIMUM_BITS = 116;

    protected static abstract class AbstractUuidDecodeStream
    extends BaseCodecSupport.AbstractDecodeStream {
        private final UuidBitMorpher uuidMorpher;
        private final int final6Bits1of2;
        private final int final6Bits2of2;

        public AbstractUuidDecodeStream(String encoded, String keyUUID, int final6Bits1of2, int final6Bits2of2) {
            super(encoded);
            this.uuidMorpher = new UuidBitMorpher(keyUUID);
            this.final6Bits1of2 = final6Bits1of2;
            this.final6Bits2of2 = final6Bits2of2;
        }

        public void consumeAndCheckTailBits() {
            int bits_1 = this.required6bits("tb1");
            int bits_2 = this.required6bits("tb2");
            if (bits_1 != this.final6Bits1of2 || bits_2 != this.final6Bits2of2) {
                throw new IllegalStateException("tb!");
            }
        }

        public void consumePaddingAndCheckTailBits() {
            this.consumeRemainingExceptNbits(12);
            this.consumeAndCheckTailBits();
        }

        @Override
        protected int morph6bits(int bits) {
            return this.uuidMorpher.morph6bits(super.morph6bits(bits));
        }
    }

    protected static abstract class AbstractUuidEncodeCollector<T extends AbstractUuidEncodeCollector<T>>
    extends BaseCodecSupport.AbstractEncodeCollector<T> {
        private final UuidBitMorpher uuidMorpher;
        private final int final6Bits1of2;
        private final int final6Bits2of2;

        protected AbstractUuidEncodeCollector(String keyUUID, int final6Bits1of2, int final6Bits2of2) {
            this.uuidMorpher = new UuidBitMorpher(keyUUID);
            this.final6Bits1of2 = final6Bits1of2;
            this.final6Bits2of2 = final6Bits2of2;
        }

        @Override
        public String result() {
            this.enforceMinimumBits(116);
            this.flushBuffer();
            this.add6bits(this.final6Bits1of2);
            this.add6bits(this.final6Bits2of2);
            return this.output.toString();
        }

        @Override
        protected int morph6bits(int bits) {
            return super.morph6bits(this.uuidMorpher.morph6bits(bits));
        }
    }

    public static class UuidBitMorpher {
        private final BitBuffer buffer = new BitBuffer();
        private final String uuid;
        private int offset;

        public UuidBitMorpher(String uuid) {
            this.uuid = uuid;
        }

        public int morph6bits(int sixBits) {
            return sixBits ^ this.ensure6Bits().remove6bits();
        }

        private BitBuffer ensure6Bits() {
            while (this.buffer.availableBits() < 6) {
                this.buffer.add4bits(Hex.from((char)this.nextChar()));
            }
            return this.buffer;
        }

        private char nextChar() {
            if (UuidNonDashCharOffsets.HEX_DIGIT_OFFSETS.length <= this.offset) {
                this.offset = 0;
            }
            return this.uuid.charAt(UuidNonDashCharOffsets.HEX_DIGIT_OFFSETS[this.offset++]);
        }
    }
}

