/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.UUID;
import org.litesoft.bitstream.OnesComplimentLongBitsBuilder;
import org.litesoft.utils.Hex;
import org.litesoft.uuid.codecsupport.BaseCodecSupport;
import org.litesoft.uuid.codecsupport.CodecSupportUUID;

public class V1_DecodeSupport
extends CodecSupportUUID {
    private final StringBuilder uuid = new StringBuilder();
    private final OnesComplimentLongBitsBuilder versionBuilder = new OnesComplimentLongBitsBuilder();
    private final DecodeStream ds;

    public V1_DecodeSupport(String encoded) {
        this.ds = new DecodeStream(encoded);
    }

    public Pair decode() {
        this.versionBuilder.withSignBit(1 & this.ds.required6bits("Initial Character"));
        int lastOffset = -1;
        for (int offset : HEX_DIGIT_OFFSETS) {
            if (++lastOffset != offset) {
                this.uuid.append('-');
                lastOffset = offset;
            }
            this.uuid.append(Hex.charFrom((int)this.ds.required4bits("Full UUID")));
        }
        this.versionBuilder.add4bits(this.ds.required4bits("Version"));
        while (0 < this.ds.availableBits()) {
            this.versionBuilder.add6bits(this.ds.required6bits("Version"));
        }
        return new Pair(UUID.fromString(this.uuid.toString()), this.versionBuilder.getValue());
    }

    private static class DecodeStream
    extends BaseCodecSupport.AbstractDecodeStream {
        public DecodeStream(String encoded) {
            super(encoded);
        }
    }

    public record Pair(UUID uuid, long version) {
    }
}

