/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.uuid.codecsupport;

import java.util.UUID;
import java.util.function.IntSupplier;
import org.litesoft.bitstream.OnesComplimentLongBitsProvider;
import org.litesoft.utils.Hex;
import org.litesoft.uuid.codecsupport.BaseCodecSupport;
import org.litesoft.uuid.codecsupport.CodecSupportUUID;

public class V1_EncodeSupport
extends CodecSupportUUID {
    private static final int FIRST_FIVE_OF_SIX_BIT_MASK = 62;
    private final String uuid;
    private final OnesComplimentLongBitsProvider bc;
    private final EncodeCollector collector;

    public V1_EncodeSupport(IntSupplier randomizingSeedSupplier, UUID uuid, long version) {
        this.uuid = uuid.toString();
        this.bc = new OnesComplimentLongBitsProvider(version);
        this.collector = new EncodeCollector(this.bc.getSignBit() + (0x3E & randomizingSeedSupplier.getAsInt()));
    }

    public String encode() {
        for (int offset : HEX_DIGIT_OFFSETS) {
            this.collector.add4bits(Hex.from((char)this.uuid.charAt(offset)));
        }
        this.collector.add4bits(this.bc.remove4bits());
        while (this.bc.isValueNonZero()) {
            this.collector.add6bits(this.bc.remove6bits());
        }
        return this.collector.result();
    }

    private static class EncodeCollector
    extends BaseCodecSupport.AbstractEncodeCollector<EncodeCollector> {
        public EncodeCollector(int initial6Bits) {
            this.add6bits(initial6Bits);
        }
    }
}

