/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.amazon.ec2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.http.client.HttpClientGetRequester;
import org.littleshoot.util.Base64;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.Pair;
import org.littleshoot.util.UriUtils;
import org.littleshoot.util.xml.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AmazonEc2CandidateProvider
implements CandidateProvider<InetAddress> {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonEc2CandidateProvider.class);
    private String m_accessKey;
    private String m_accessKeyId;
    private Collection<InetAddress> m_lastValidAddresses = new LinkedList<InetAddress>();
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public AmazonEc2CandidateProvider(String accessKeyId, String accessKey) {
        this.m_accessKeyId = accessKeyId;
        this.m_accessKey = accessKey;
    }

    public Collection<InetAddress> getInstanceAddresses(String groupId) {
        if (StringUtils.isBlank((String)this.m_accessKeyId) || StringUtils.isBlank((String)this.m_accessKey)) {
            throw new IllegalArgumentException("Keys not set");
        }
        HttpClientGetRequester requester = new HttpClientGetRequester();
        LinkedList<Pair<String, String>> params = new LinkedList<Pair<String, String>>();
        params.add(UriUtils.pair((String)"Action", (String)"DescribeInstances"));
        params.add(UriUtils.pair((String)"AWSAccessKeyId", (String)this.m_accessKeyId));
        params.add(UriUtils.pair((String)"SignatureVersion", (long)1L));
        String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = sdf.format(new Date());
        LOG.debug("Using date: {}", (Object)date);
        params.add(UriUtils.pair((String)"Timestamp", (String)date));
        params.add(UriUtils.pair((String)"Version", (String)"2007-08-29"));
        String sig = this.calculateRfc2104Hmac(params);
        params.add((Pair<String, String>)UriUtils.pair((String)"Signature", (String)sig));
        try {
            String body = requester.request("https://ec2.amazonaws.com/", params);
            LOG.debug("Received body");
            return this.extractInetAddresses(groupId, body);
        }
        catch (Exception e) {
            LOG.error("Error accessing server data", (Throwable)e);
            return this.m_lastValidAddresses;
        }
    }

    private Collection<InetAddress> extractInetAddresses(String groupId, String body) {
        LinkedList<InetAddress> addresses = new LinkedList<InetAddress>();
        try {
            XPathUtils xPath = XPathUtils.newXPath((String)body);
            String path = "/DescribeInstancesResponse/reservationSet/item[groupSet/item[groupId='" + groupId + "']]/instancesSet/item/";
            path = path + "dnsName";
            NodeList nodes = xPath.getNodes(path);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String urlString = node.getTextContent();
                if (StringUtils.isBlank((String)urlString)) {
                    LOG.debug("Not using blank address");
                    continue;
                }
                try {
                    InetAddress address = InetAddress.getByName(urlString);
                    addresses.add(address);
                    continue;
                }
                catch (UnknownHostException e) {
                    LOG.warn("Unknown host: " + urlString, (Throwable)e);
                }
            }
        }
        catch (SAXException e) {
            LOG.error("SAX error", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IO error!", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            LOG.error("XPath error!!", (Throwable)e);
        }
        this.m_lastValidAddresses = addresses;
        Collections.shuffle(addresses);
        return addresses;
    }

    private String calculateRfc2104Hmac(List<Pair<String, String>> params) {
        Comparator<Pair<String, String>> comparator = new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> param1, Pair<String, String> param2) {
                return ((String)param1.getFirst()).compareToIgnoreCase((String)param2.getFirst());
            }
        };
        Collections.sort(params, comparator);
        StringBuilder sb = new StringBuilder();
        for (Pair<String, String> param : params) {
            sb.append((String)param.getFirst());
            sb.append((String)param.getSecond());
        }
        String urlString = sb.toString();
        LOG.debug("Using string: {}", (Object)urlString);
        return this.calculateRfc2104Hmac(urlString);
    }

    private String calculateRfc2104Hmac(String data) {
        SecretKeySpec signingKey = new SecretKeySpec(this.m_accessKey.getBytes(), HMAC_SHA1_ALGORITHM);
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            return Base64.encodeBytes((byte[])rawHmac);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("No algorithm", (Throwable)e);
            throw new RuntimeException("Bad algorithm", e);
        }
        catch (InvalidKeyException e) {
            LOG.error("Bad key", (Throwable)e);
            throw new RuntimeException("Bad key", e);
        }
    }

    public InetAddress getCandidate() {
        Collection<InetAddress> addresses = this.getInstanceAddresses("sip-turn");
        return addresses.iterator().next();
    }

    public Collection<InetAddress> getCandidates() {
        return this.getInstanceAddresses("sip-turn");
    }
}

