/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.amazon.ec2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.littleshoot.util.DefaultHttpClientImpl;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonEc2Utils {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonEc2Utils.class);
    private static InetAddress s_cachedAddress;
    private static long s_lastUpdateTime;

    private AmazonEc2Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getPublicAddress() {
        LOG.debug("Getting public address");
        long now = System.currentTimeMillis();
        if (now - s_lastUpdateTime < 60000L) {
            LOG.debug("Using cached address...");
            return s_cachedAddress;
        }
        try {
            if (!AmazonEc2Utils.onEc2()) {
                LOG.debug("Not running on EC2.");
                return NetworkUtils.getLocalHost();
            }
        }
        catch (UnknownHostException e) {
            LOG.error("Could not get host.", (Throwable)e);
            return null;
        }
        String url = "http://169.254.169.254/latest/meta-data/public-ipv4";
        DefaultHttpClientImpl client = new DefaultHttpClientImpl();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
        GetMethod method = new GetMethod("http://169.254.169.254/latest/meta-data/public-ipv4");
        try {
            LOG.debug("Executing method...");
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                LOG.warn("ERROR ISSUING REQUEST:\n" + method.getStatusLine() + "\n" + method.getResponseBodyAsString());
                InetAddress inetAddress = null;
                return inetAddress;
            }
            LOG.debug("Successfully received response...");
            String host = method.getResponseBodyAsString();
            LOG.debug("Got address: " + host);
            s_cachedAddress = InetAddress.getByName(host);
            s_lastUpdateTime = System.currentTimeMillis();
            InetAddress inetAddress = s_cachedAddress;
            return inetAddress;
        }
        catch (HttpException e) {
            LOG.error("Could not access EC2 service", (Throwable)e);
            InetAddress inetAddress = null;
            return inetAddress;
        }
        catch (IOException e) {
            LOG.error("Could not access EC2 service", (Throwable)e);
            InetAddress inetAddress = null;
            return inetAddress;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static boolean onEc2() {
        try {
            String local = NetworkUtils.getLocalHost().getHostAddress();
            return local.startsWith("10.25") || local.startsWith("10.241") || local.startsWith("10.191");
        }
        catch (UnknownHostException e) {
            LOG.warn("Unknown host", (Throwable)e);
            return false;
        }
    }

    static {
        s_lastUpdateTime = 0L;
    }
}

