/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.littleshoot.proxy.DefaultProxyAuthorizationManager;
import org.littleshoot.proxy.DefaultRelayPipelineFactoryFactory;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.HttpServerPipelineFactory;
import org.littleshoot.proxy.KeyStoreManager;
import org.littleshoot.proxy.NetworkUtils;
import org.littleshoot.proxy.ProxyAuthorizationHandler;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpProxyServer
implements HttpProxyServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ChannelGroup allChannels = new DefaultChannelGroup("HTTP-Proxy-Server");
    private final int port;
    private final ProxyAuthorizationManager authenticationManager = new DefaultProxyAuthorizationManager();
    private final Map<String, HttpFilter> filters;
    private final String chainProxyHostAndPort;
    private final KeyStoreManager ksm;
    private final HttpRequestFilter requestFilter;
    private final ServerBootstrap serverBootstrap;

    public DefaultHttpProxyServer(int port) {
        this(port, new HashMap<String, HttpFilter>());
    }

    public DefaultHttpProxyServer(int port, Map<String, HttpFilter> filters) {
        this(port, filters, null, null, null);
    }

    public DefaultHttpProxyServer(int port, HttpRequestFilter requestFilter, Map<String, HttpFilter> responseFilters) {
        this(port, responseFilters, null, null, requestFilter);
    }

    public DefaultHttpProxyServer(int port, Map<String, HttpFilter> filters, String chainProxyHostAndPort, KeyStoreManager ksm, HttpRequestFilter requestFilter) {
        this.port = port;
        this.ksm = ksm;
        this.requestFilter = requestFilter;
        this.filters = Collections.unmodifiableMap(filters);
        this.chainProxyHostAndPort = chainProxyHostAndPort;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                DefaultHttpProxyServer.this.log.error("Uncaught throwable", e);
            }
        });
        this.serverBootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
    }

    @Override
    public void start() {
        this.start(false, true);
    }

    @Override
    public void start(boolean localOnly, boolean anyAddress) {
        InetSocketAddress isa;
        this.log.info("Starting proxy on port: " + this.port);
        HttpServerPipelineFactory factory = new HttpServerPipelineFactory(this.authenticationManager, this.allChannels, this.chainProxyHostAndPort, this.ksm, new DefaultRelayPipelineFactoryFactory(this.chainProxyHostAndPort, this.filters, this.requestFilter, this.allChannels));
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)factory);
        if (localOnly) {
            isa = new InetSocketAddress("127.0.0.1", this.port);
        } else if (anyAddress) {
            isa = new InetSocketAddress(this.port);
        } else {
            try {
                isa = new InetSocketAddress(NetworkUtils.getLocalHost(), this.port);
            }
            catch (UnknownHostException e) {
                this.log.error("Could not get local host?", (Throwable)e);
                isa = new InetSocketAddress(this.port);
            }
        }
        Channel channel = this.serverBootstrap.bind((SocketAddress)isa);
        this.allChannels.add((Object)channel);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                DefaultHttpProxyServer.this.stop();
            }
        }));
    }

    @Override
    public void stop() {
        this.log.info("Shutting down proxy");
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly(6000L);
        this.serverBootstrap.releaseExternalResources();
        this.log.info("Done shutting down proxy");
    }

    @Override
    public void addProxyAuthenticationHandler(ProxyAuthorizationHandler pah) {
        this.authenticationManager.addHandler(pah);
    }

    public KeyStoreManager getKeyStoreManager() {
        return this.ksm;
    }
}

