/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.littleshoot.proxy.CachedHttpResponse;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyCacheManager
implements ProxyCacheManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CacheManager cacheManager = new CacheManager();
    private static final boolean CACHE_ENABLED = false;
    private final ExecutorService cacheExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private int numThreads = 0;

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Cache-Insertion-Thread-" + this.numThreads);
            ++this.numThreads;
            t.setDaemon(true);
            return t;
        }
    });

    public DefaultProxyCacheManager() {
        this.cacheManager.addCache("DEFAULT_CACHE");
        this.cacheManager.addCache("CHUNKS_CACHE");
        this.cacheManager.addCache("CHUNK_CACHE");
    }

    @Override
    public boolean returnCacheHit(HttpRequest httpRequest, Channel channel) {
        String uri = ProxyUtils.cacheUri(httpRequest);
        Cache cache = this.cacheManager.getCache("DEFAULT_CACHE");
        Element elem = cache.get((Serializable)((Object)uri));
        if (elem != null) {
            this.log.info("Found element in cache for URI: {}", (Object)uri);
            CachedHttpResponse cached = (CachedHttpResponse)elem.getObjectValue();
            ChannelFutureListener cfl = cached.getChannelFutureListener();
            ChannelFuture cf = channel.write((Object)cached.getChannelBuffer());
            cf.addListener(cfl);
            this.log.info("Wrote response from cache!!");
            return true;
        }
        return false;
    }

    @Override
    public Future<String> cache(HttpRequest httpRequest, HttpResponse httpResponse, Object response, ChannelBuffer encoded) {
        return null;
    }

    private boolean isCacheable(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.log.info("Cache is not enabled");
        return false;
    }
}

