/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.net.ssl.SSLEngine;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.ssl.SslHandler;
import org.littleshoot.proxy.AllConnectionData;
import org.littleshoot.proxy.HttpRequestHandler;
import org.littleshoot.proxy.KeyStoreManager;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyHttpResponseEncoder;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;
import org.littleshoot.proxy.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerPipelineFactory
implements ChannelPipelineFactory,
AllConnectionData {
    private static final Logger log = LoggerFactory.getLogger(HttpServerPipelineFactory.class);
    private static final boolean CACHE_ENABLED = false;
    private final ProxyAuthorizationManager authenticationManager;
    private final ChannelGroup channelGroup;
    private final String chainProxyHostAndPort;
    private final ClientSocketChannelFactory clientSocketChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    private final ProxyCacheManager cacheManager;
    private final KeyStoreManager ksm;
    private int numHandlers;
    private boolean useJmx;
    private final RelayPipelineFactoryFactory relayPipelineFactoryFactory;

    public HttpServerPipelineFactory(ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, String chainProxyHostAndPort, KeyStoreManager ksm, RelayPipelineFactoryFactory relayPipelineFactoryFactory) {
        this.relayPipelineFactoryFactory = relayPipelineFactoryFactory;
        log.info("Creating server with keystore manager: {}", (Object)ksm);
        this.authenticationManager = authorizationManager;
        this.channelGroup = channelGroup;
        this.chainProxyHostAndPort = chainProxyHostAndPort;
        this.ksm = ksm;
        this.cacheManager = new ProxyCacheManager(){

            @Override
            public boolean returnCacheHit(HttpRequest request, Channel channel) {
                return false;
            }

            @Override
            public Future<String> cache(HttpRequest originalRequest, HttpResponse httpResponse, Object response, ChannelBuffer encoded) {
                return null;
            }
        };
        Properties props = new Properties();
        File propsFile = new File("./littleproxy.properties");
        long readThrottle = -1L;
        long writeThrottle = -1L;
        try {
            FileInputStream is = new FileInputStream(propsFile);
            props.load(is);
            this.useJmx = this.extractBoolean(props, "jmx");
            if (this.useJmx) {
                this.setupJmx();
            }
        }
        catch (IOException e) {
            log.info("Not using props file");
        }
        if (readThrottle != -1L || writeThrottle != -1L) {
            log.info("Traffic shaping writes at {} bytes per second", (Object)writeThrottle);
            log.info("Traffic shaping reads at {} bytes per second", (Object)readThrottle);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                HttpServerPipelineFactory.this.clientSocketChannelFactory.releaseExternalResources();
            }
        }));
    }

    private void setupJmx() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<?> clazz = this.getClass();
            String pack = clazz.getPackage().getName();
            String oName = pack + ":type=" + clazz.getSimpleName() + "-" + clazz.getSimpleName() + this.hashCode();
            log.info("Registering MBean with name: {}", (Object)oName);
            ObjectName mxBeanName = new ObjectName(oName);
            if (!mbs.isRegistered(mxBeanName)) {
                mbs.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
    }

    private boolean extractBoolean(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank((String)throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return false;
    }

    private long extractLong(Properties props, String key) {
        String readThrottleString = props.getProperty(key);
        if (StringUtils.isNotBlank((String)readThrottleString) && NumberUtils.isNumber((String)readThrottleString)) {
            return Long.parseLong(readThrottleString);
        }
        return -1L;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        log.info("Accessing pipeline");
        if (this.ksm != null) {
            log.info("Adding SSL handler");
            SslContextFactory scf = new SslContextFactory(this.ksm);
            SSLEngine engine = scf.getServerContext().createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(8192, 16384, 16384));
        pipeline.addLast("encoder", (ChannelHandler)new ProxyHttpResponseEncoder(this.cacheManager));
        pipeline.addLast("handler", (ChannelHandler)new HttpRequestHandler(this.cacheManager, this.authenticationManager, this.channelGroup, this.clientSocketChannelFactory, this.chainProxyHostAndPort, this.relayPipelineFactoryFactory, this.useJmx));
        ++this.numHandlers;
        return pipeline;
    }

    public int getNumRequestHandlers() {
        return this.numHandlers;
    }
}

