/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import org.liveontologies.puli.AcyclicDerivableProofStep;
import org.liveontologies.puli.ConvertedProofNode;
import org.liveontologies.puli.ConvertedProofStep;
import org.liveontologies.puli.DerivabilityCheckerWithBlocking;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofNodeDerivabilityChecker;
import org.liveontologies.puli.ProofStep;

class AcyclicDerivableProofNode<C>
extends ConvertedProofNode<C> {
    private final AcyclicDerivableProofNode<C> parent_;
    private final DerivabilityCheckerWithBlocking<ProofNode<?>> checker_;

    AcyclicDerivableProofNode(ProofNode<C> delegate, AcyclicDerivableProofNode<C> parent, DerivabilityCheckerWithBlocking<ProofNode<?>> checker) {
        super(delegate);
        this.parent_ = parent;
        this.checker_ = checker;
    }

    AcyclicDerivableProofNode(ProofNode<C> delegate) {
        this(delegate, null, new ProofNodeDerivabilityChecker());
    }

    @Override
    protected void convertInferences() {
        Preconditions.checkArgument((boolean)this.checker_.getBlockedConclusions().isEmpty());
        AcyclicDerivableProofNode<C> blocked = this;
        do {
            this.checker_.block((ProofNode<?>)blocked.getDelegate());
        } while ((blocked = blocked.parent_) != null);
        super.convertInferences();
        blocked = this;
        do {
            this.checker_.unblock((ProofNode<?>)blocked.getDelegate());
        } while ((blocked = blocked.parent_) != null);
    }

    @Override
    protected final void convert(ConvertedProofStep<C> step) {
        ProofStep delegate = (ProofStep)step.getDelegate();
        for (ProofNode premise : delegate.getPremises()) {
            if (this.checker_.isDerivable(premise)) continue;
            return;
        }
        this.convert(new AcyclicDerivableProofStep(delegate, this, this.checker_));
    }

    @Override
    void convert(AcyclicDerivableProofStep<C> step) {
        super.convert(step);
    }
}

