/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.liveontologies.puli.DynamicProof;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.ModifiableProof;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseProof<I extends Inference<?>>
implements ModifiableProof<I>,
DynamicProof<I> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(BaseProof.class);
    private final Map<Object, Collection<I>> inferences_ = new HashMap<Object, Collection<I>>();
    private final Set<Object> queried_ = new HashSet<Object>();
    private final List<DynamicProof.ChangeListener> listeners_ = new ArrayList<DynamicProof.ChangeListener>();

    @Override
    public Collection<? extends I> getInferences(Object conclusion) {
        this.queried_.add(conclusion);
        Collection<I> result = this.inferences_.get(conclusion);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void addListener(DynamicProof.ChangeListener listener) {
        this.listeners_.add(listener);
    }

    @Override
    public void removeListener(DynamicProof.ChangeListener listener) {
        this.listeners_.remove(listener);
    }

    @Override
    public void produce(I inference) {
        LOGGER_.trace("{}: inference added", inference);
        Object conclusion = inference.getConclusion();
        Collection<I> existing = this.inferences_.get(conclusion);
        if (existing == null) {
            existing = new ArrayList<I>();
            this.inferences_.put(conclusion, existing);
        }
        existing.add(inference);
        if (this.queried_.contains(conclusion)) {
            this.fireChanged();
        }
    }

    @Override
    public void clear() {
        if (this.inferences_.isEmpty()) {
            return;
        }
        LOGGER_.trace("inferences cleared");
        this.inferences_.clear();
        if (!this.queried_.isEmpty()) {
            this.fireChanged();
        }
    }

    protected void fireChanged() {
        this.queried_.clear();
        for (DynamicProof.ChangeListener listener : this.listeners_) {
            listener.inferencesChanged();
        }
    }

    @Override
    public void dispose() {
    }
}

