/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import org.liveontologies.puli.AbstractProofNode;
import org.liveontologies.puli.BaseProofStep;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.ProofStep;

class BaseProofNode<C>
extends AbstractProofNode<C> {
    private final Proof<? extends Inference<? extends C>> proof_;
    private Collection<ProofStep<C>> steps_ = null;

    BaseProofNode(Proof<? extends Inference<? extends C>> proof, C member) {
        super(member);
        Preconditions.checkNotNull(proof);
        this.proof_ = proof;
    }

    public Proof<? extends Inference<? extends C>> getProof() {
        return this.proof_;
    }

    @Override
    public Collection<? extends ProofStep<C>> getInferences() {
        if (this.steps_ == null) {
            Collection<Inference<C>> original = this.proof_.getInferences(this.getMember());
            this.steps_ = new ArrayList<ProofStep<C>>(original.size());
            for (Inference<? extends C> inference : original) {
                this.convert(inference);
            }
        }
        return this.steps_;
    }

    void convert(Inference<? extends C> inf) {
        this.steps_.add(new BaseProofStep<C>(this.proof_, inf));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BaseProofNode) {
            BaseProofNode other = (BaseProofNode)o;
            return this.getMember().equals(other.getMember()) && this.proof_.equals(other.proof_);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BaseProofNode.class.hashCode() + this.getMember().hashCode() + this.proof_.hashCode();
    }
}

