/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.List;
import org.liveontologies.puli.AbstractProofStep;
import org.liveontologies.puli.BaseProofNode;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.ProofNode;

class BaseProofStep<C>
extends AbstractProofStep<C> {
    private final Proof<? extends Inference<? extends C>> proof_;
    private final Inference<? extends C> inference_;

    BaseProofStep(Proof<? extends Inference<? extends C>> proof, Inference<? extends C> inference) {
        Preconditions.checkNotNull(proof);
        Preconditions.checkNotNull(inference);
        this.proof_ = proof;
        this.inference_ = inference;
    }

    public Proof<? extends Inference<? extends C>> getProof() {
        return this.proof_;
    }

    @Override
    public Inference<? extends C> getInference() {
        return this.inference_;
    }

    @Override
    public String getName() {
        return this.inference_.getName();
    }

    @Override
    public ProofNode<C> getConclusion() {
        return this.convert(this.inference_.getConclusion());
    }

    @Override
    public List<? extends ProofNode<C>> getPremises() {
        return new AbstractList<ProofNode<C>>(){

            @Override
            public ProofNode<C> get(int index) {
                return BaseProofStep.this.convert(BaseProofStep.this.inference_.getPremises().get(index));
            }

            @Override
            public int size() {
                return BaseProofStep.this.inference_.getPremises().size();
            }
        };
    }

    ProofNode<C> convert(C member) {
        return new BaseProofNode<C>(this.proof_, member);
    }
}

