/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import org.liveontologies.puli.AddAssertedProofNode;
import org.liveontologies.puli.DerivabilityChecker;
import org.liveontologies.puli.DerivableFromProofStep;
import org.liveontologies.puli.DerivableProofNode;
import org.liveontologies.puli.DerivableProofStep;
import org.liveontologies.puli.Inferences;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofNodeDerivabilityChecker;
import org.liveontologies.puli.ProofStep;

class DerivableFromProofNode<C>
extends DerivableProofNode<C> {
    DerivableFromProofNode(ProofNode<C> delegate, DerivabilityChecker<ProofNode<?>> checker) {
        super(delegate, checker);
    }

    DerivableFromProofNode(ProofNode<C> delegate, Set<? extends C> statedAxioms) {
        this(new AddAssertedProofNode<C>(delegate, statedAxioms), new ProofNodeDerivabilityChecker());
    }

    @Override
    public Collection<ProofStep<C>> getInferences() {
        Collection result = super.getInferences();
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0);
        return result;
    }

    @Override
    final void convert(DerivableProofStep<C> step) {
        ProofStep delegate = (ProofStep)step.getDelegate();
        if (Inferences.isAsserted(delegate)) {
            return;
        }
        this.convert(new DerivableFromProofStep(delegate, this.getDerivabilityChecker()));
    }

    @Override
    void convert(DerivableFromProofStep<C> step) {
        super.convert(step);
    }
}

