/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.liveontologies.puli.ConvertedProofNode;
import org.liveontologies.puli.ConvertedProofStep;
import org.liveontologies.puli.DerivabilityChecker;
import org.liveontologies.puli.DerivableProofStep;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofNodeDerivabilityChecker;
import org.liveontologies.puli.ProofStep;

class DerivableProofNode<C>
extends ConvertedProofNode<C> {
    private final DerivabilityChecker<ProofNode<?>> checker_;

    DerivableProofNode(ProofNode<C> delegate, DerivabilityChecker<ProofNode<?>> checker) {
        super(delegate);
        Preconditions.checkNotNull(checker);
        this.checker_ = checker;
    }

    DerivableProofNode(ProofNode<C> delegate) {
        this(delegate, new ProofNodeDerivabilityChecker());
    }

    DerivabilityChecker<ProofNode<?>> getDerivabilityChecker() {
        return this.checker_;
    }

    @Override
    public Collection<ProofStep<C>> getInferences() {
        Collection result = super.getInferences();
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0);
        return result;
    }

    @Override
    protected final void convert(ConvertedProofStep<C> step) {
        ProofStep delegate = (ProofStep)step.getDelegate();
        for (ProofNode premise : delegate.getPremises()) {
            if (this.checker_.isDerivable(premise)) continue;
            return;
        }
        this.convert(new DerivableProofStep(delegate, this.checker_));
    }

    @Override
    void convert(DerivableProofStep<C> step) {
        super.convert(step);
    }
}

