/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.liveontologies.puli.ConvertedProofNode;
import org.liveontologies.puli.ConvertedProofStep;
import org.liveontologies.puli.FilteredProofStep;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilteredProofNode<C>
extends ConvertedProofNode<C> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(FilteredProofNode.class);
    private final Set<? extends ProofNode<C>> forbidden_;

    FilteredProofNode(ProofNode<C> delegate, Set<? extends ProofNode<C>> forbidden) {
        super(delegate);
        Preconditions.checkNotNull(forbidden);
        this.forbidden_ = forbidden;
    }

    @Override
    protected final void convert(ConvertedProofStep<C> step) {
        ProofStep delegate = (ProofStep)step.getDelegate();
        for (ProofNode premise : delegate.getPremises()) {
            if (!this.forbidden_.contains(premise)) continue;
            LOGGER_.trace("{}: ignored: {} is forbiden", (Object)delegate, (Object)premise);
            return;
        }
        this.convert(new FilteredProofStep(delegate, this.forbidden_));
    }

    @Override
    void convert(FilteredProofStep<C> step) {
        super.convert(step);
    }
}

