/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.liveontologies.puli.DerivabilityCheckerWithBlocking;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Proof;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferenceDerivabilityChecker<C, I extends Inference<? extends C>>
implements DerivabilityCheckerWithBlocking<C> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(InferenceDerivabilityChecker.class);
    private final Proof<? extends I> proof_;
    private final Set<C> blocked_ = new HashSet<C>();
    private final Queue<C> toBlock_ = new ArrayDeque<C>(32);
    private final Queue<C> toUnblock_ = new ArrayDeque<C>(32);
    private final Set<C> derivable_ = new HashSet<C>();
    private final ListMultimap<C, I> watchedInferences_ = ArrayListMultimap.create();
    private final ListMultimap<C, Integer> watchPremisePositions_ = ArrayListMultimap.create();
    private final SetMultimap<C, I> firedInferencesByPremises_ = HashMultimap.create();
    private final ListMultimap<C, I> firedInferencesByConclusions_ = ArrayListMultimap.create();
    private final Map<C, Queue<I>> remainingInferences_ = new HashMap<C, Queue<I>>();
    private final Set<C> goals_ = new HashSet<C>();
    private final Deque<C> toCheck_ = new ArrayDeque<C>(128);
    private final Deque<C> toSetUnknown_ = new ArrayDeque<C>(128);
    private final Queue<C> toPropagate_ = new LinkedList<C>();

    public InferenceDerivabilityChecker(Proof<? extends I> proof) {
        Preconditions.checkNotNull(proof);
        this.proof_ = proof;
    }

    @Override
    public boolean isDerivable(C conclusion) {
        LOGGER_.trace("{}: checking derivability", conclusion);
        this.initBlocking();
        this.toCheck(conclusion);
        this.process();
        boolean derivable = this.derivable_.contains(conclusion);
        LOGGER_.trace("{}: derivable: {}", conclusion, (Object)derivable);
        return derivable;
    }

    @Override
    public Set<C> getBlockedConclusions() {
        return this.blocked_;
    }

    @Override
    public boolean block(C conclusion) {
        if (this.blocked_.add(conclusion)) {
            LOGGER_.trace("{}: blocked", conclusion);
            this.toBlock_.add(conclusion);
            return true;
        }
        return false;
    }

    @Override
    public boolean unblock(C conclusion) {
        if (this.blocked_.remove(conclusion)) {
            LOGGER_.trace("{}: unblocked", conclusion);
            this.toUnblock_.add(conclusion);
            return true;
        }
        return false;
    }

    public Set<? extends C> getNonDerivableConclusions() {
        return this.watchedInferences_.keySet();
    }

    private void initBlocking() {
        C next;
        while ((next = this.toBlock_.poll()) != null) {
            if (!this.blocked_.contains(next)) continue;
            this.setUnknown(next);
        }
        while ((next = this.toUnblock_.poll()) != null) {
            if (this.blocked_.contains(next)) continue;
            if (this.derivable_.contains(next)) {
                this.toPropagate_.add(next);
                continue;
            }
            if (!this.goals_.contains(next)) continue;
            this.toCheck_.addFirst(next);
        }
    }

    private void toCheck(C conclusion) {
        if (this.goals_.add(conclusion)) {
            LOGGER_.trace("{}: new goal", conclusion);
            if (this.blocked_.contains(conclusion)) {
                LOGGER_.trace("{}: goal blocked", conclusion);
                return;
            }
            this.toCheck_.addFirst(conclusion);
        }
    }

    private void derivable(C conclusion) {
        if (this.derivable_.add(conclusion)) {
            LOGGER_.trace("{}: derived", conclusion);
            if (!this.blocked_.contains(conclusion)) {
                this.toPropagate_.add(conclusion);
            }
        }
    }

    private void process() {
        block0: while (true) {
            C derivable;
            if ((derivable = this.toPropagate_.poll()) != null) {
                List watched = this.watchedInferences_.removeAll(derivable);
                List positions = this.watchPremisePositions_.removeAll(derivable);
                int i = 0;
                while (true) {
                    if (i >= watched.size()) continue block0;
                    Inference inf = (Inference)watched.get(i);
                    int pos = (Integer)positions.get(i);
                    this.check(pos, inf);
                    ++i;
                }
            }
            C unknown = this.toCheck_.peek();
            if (unknown == null) break;
            if (this.derivable_.contains(unknown)) {
                this.toCheck_.poll();
                continue;
            }
            Queue<I> inferences = this.getRemainingInferences(unknown);
            Inference inf = (Inference)inferences.poll();
            if (inf == null) {
                this.toCheck_.poll();
                continue;
            }
            LOGGER_.trace("{}: expanding", (Object)inf);
            this.check(0, inf);
        }
    }

    private Queue<I> getRemainingInferences(C conclusion) {
        Queue<I> result = this.remainingInferences_.get(conclusion);
        if (result == null) {
            result = new ArrayDeque<I>(this.proof_.getInferences(conclusion));
            this.remainingInferences_.put(conclusion, result);
        }
        return result;
    }

    private void check(int pos, I inf) {
        List premises = inf.getPremises();
        int premiseCount = premises.size();
        int premisesChecked = 0;
        while (true) {
            if (premisesChecked == premiseCount) {
                this.fire(inf);
                return;
            }
            Object premise = premises.get(pos);
            if (!this.derivable_.contains(premise)) {
                this.addWatch(premise, pos, inf);
                return;
            }
            if (++pos == premiseCount) {
                pos = 0;
            }
            ++premisesChecked;
        }
    }

    private void fire(I inf) {
        LOGGER_.trace("{}: fire", inf);
        Object conclusion = inf.getConclusion();
        this.derivable(conclusion);
        this.firedInferencesByConclusions_.put(inf.getConclusion(), inf);
        List premises = inf.getPremises();
        for (int pos = 0; pos < premises.size(); ++pos) {
            this.firedInferencesByPremises_.put(premises.get(pos), inf);
        }
    }

    private void addWatch(C premise, int pos, I inf) {
        LOGGER_.trace("{}: watching position {}", inf, (Object)pos);
        List inferences = this.watchedInferences_.get(premise);
        List positions = this.watchPremisePositions_.get(premise);
        inferences.add(inf);
        positions.add(pos);
        this.toCheck(premise);
    }

    void setUnknown(C conclusion) {
        this.toSetUnknown_.add(conclusion);
        while ((conclusion = this.toSetUnknown_.poll()) != null) {
            if (!this.derivable_.remove(conclusion)) continue;
            LOGGER_.trace("{}: unknown goal", conclusion);
            if (!this.blocked_.contains(conclusion)) {
                this.toCheck_.addLast(conclusion);
            }
            List fired = this.firedInferencesByConclusions_.removeAll(conclusion);
            for (Inference inf : fired) {
                for (Object premise : inf.getPremises()) {
                    this.firedInferencesByPremises_.remove(premise, (Object)inf);
                }
            }
            this.getRemainingInferences(conclusion).addAll(fired);
            for (Inference inf : this.firedInferencesByPremises_.get(conclusion)) {
                this.toSetUnknown_.add(inf.getConclusion());
            }
        }
    }
}

