/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Producer;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.Proofs;

class InferenceExpander<C, I extends Inference<? extends C>>
implements Producer<I> {
    private final Set<C> derivable_;
    private final Proof<? extends I> proof_;
    private final ListMultimap<C, I> watchInferences_ = ArrayListMultimap.create();
    private final ListMultimap<C, Integer> watchPositions_ = ArrayListMultimap.create();
    private final Queue<C> newlyDerived_ = new ArrayDeque<C>();
    private final Producer<? super I> producer_;

    InferenceExpander(Set<C> derivable, Proof<? extends I> proof, C goal, Producer<? super I> producer) {
        this.proof_ = proof;
        this.derivable_ = derivable;
        this.producer_ = producer;
        this.process(goal);
    }

    public static <C, I extends Inference<? extends C>> void expand(Set<C> derivable, Proof<? extends I> proof, C goal, Producer<? super I> producer) {
        new InferenceExpander<C, I>(derivable, proof, goal, producer);
    }

    void process(C goal) {
        Proofs.unfoldRecursively(this.proof_, goal, this);
    }

    @Override
    public void produce(I inf) {
        List premises = inf.getPremises();
        for (int i = 0; i < premises.size(); ++i) {
            Object premise = premises.get(i);
            if (this.derivable_.contains(premise)) continue;
            this.watchInferences_.put(premise, inf);
            this.watchPositions_.put(premise, (Object)i);
            return;
        }
        Object conclusion = inf.getConclusion();
        if (this.derivable_.add(conclusion)) {
            this.producer_.produce(inf);
            this.newlyDerived_.add(conclusion);
            this.propagate();
        }
    }

    void propagate() {
        C next;
        block0: while ((next = this.newlyDerived_.poll()) != null) {
            List watch = this.watchInferences_.removeAll(next);
            List positions = this.watchPositions_.removeAll(next);
            int i = 0;
            while (true) {
                block5: {
                    Object premise;
                    if (i >= watch.size()) continue block0;
                    Inference inf = (Inference)watch.get(i);
                    int pos = (Integer)positions.get(i);
                    List premises = inf.getPremises();
                    do {
                        if (++pos != premises.size()) continue;
                        Object conclusion = inf.getConclusion();
                        if (this.derivable_.add(conclusion)) {
                            this.producer_.produce(inf);
                            this.newlyDerived_.add(conclusion);
                        }
                        break block5;
                    } while (this.derivable_.contains(premise = premises.get(pos)));
                    this.watchInferences_.put(premise, (Object)inf);
                    this.watchPositions_.put(premise, (Object)pos);
                }
                ++i;
            }
            break;
        }
        return;
    }
}

