/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import org.liveontologies.puli.AssertedConclusionInference;
import org.liveontologies.puli.BaseInference;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.TransformedInference;

public class Inferences {
    public static <C> Inference<C> create(String name, C conclusion, List<? extends C> premises) {
        return new BaseInference<C>(name, conclusion, premises);
    }

    public static boolean isAsserted(Inference<?> inference) {
        return AssertedConclusionInference.NAME.equals(inference.getName());
    }

    public static <F, T> Inference<T> transform(Inference<? extends F> inference, Function<? super F, ? extends T> function) {
        return new TransformedInference<F, T>(inference, function);
    }

    public static boolean equals(Inference<?> inference, Object o) {
        if (o instanceof Inference) {
            Inference other = (Inference)o;
            return inference.getName().equals(other.getName()) && inference.getConclusion().equals(other.getConclusion()) && inference.getPremises().equals(other.getPremises());
        }
        return false;
    }

    public static int hashCode(Inference<?> inference) {
        if (inference == null) {
            return 0;
        }
        return inference.getName().hashCode() + inference.getConclusion().hashCode() + inference.getPremises().hashCode();
    }

    public static String toString(Inference<?> inference) {
        Preconditions.checkNotNull(inference);
        return inference.getConclusion() + " -| " + inference.getPremises() + " by " + inference.getName();
    }
}

