/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import java.util.Set;
import org.liveontologies.puli.AcyclicDerivableProofNode;
import org.liveontologies.puli.AddAssertedProofNode;
import org.liveontologies.puli.BaseProofNode;
import org.liveontologies.puli.DerivableProofNode;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Proof;
import org.liveontologies.puli.ProofNode;
import org.liveontologies.puli.ProofNodeDerivabilityChecker;
import org.liveontologies.puli.RemoveAssertedProofNode;

public class ProofNodes {
    public static <C> ProofNode<C> create(Proof<? extends Inference<? extends C>> proof, C member) {
        return new BaseProofNode<C>(proof, member);
    }

    public static <C> ProofNode<C> addAssertedInferences(ProofNode<C> node, Set<? extends C> assertedConclusions) {
        return new AddAssertedProofNode<C>(node, assertedConclusions);
    }

    public static <C> ProofNode<C> removeAssertedInferences(ProofNode<C> node) {
        return new RemoveAssertedProofNode<C>(node);
    }

    public static <C> boolean isDerivable(ProofNode<C> node) {
        return new ProofNodeDerivabilityChecker().isDerivable(node);
    }

    public static <C> ProofNode<C> eliminateNotDerivable(ProofNode<C> node) {
        if (ProofNodes.isDerivable(node)) {
            return new DerivableProofNode<C>(node);
        }
        return null;
    }

    public static <C> ProofNode<C> eliminateNotDerivableAndCycles(ProofNode<C> node) {
        if (ProofNodes.isDerivable(node)) {
            return new AcyclicDerivableProofNode<C>(node);
        }
        return null;
    }
}

