/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.liveontologies.puli.BaseInferenceJustifier;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.InferenceJustifier;
import org.liveontologies.puli.Proof;

public class ProofPrinter<C, I extends Inference<? extends C>, A> {
    private final Proof<? extends I> proof_;
    private final InferenceJustifier<? super I, ? extends Set<? extends A>> justifier_;
    private final Deque<Iterator<? extends I>> inferenceStack_ = new LinkedList<Iterator<? extends I>>();
    private final Deque<Iterator<? extends C>> conclusionStack_ = new LinkedList<Iterator<? extends C>>();
    private final Deque<Iterator<? extends A>> justificationStack_ = new LinkedList<Iterator<? extends A>>();
    private final Set<C> printed_ = new HashSet<C>();
    private final BufferedWriter writer_;

    protected ProofPrinter(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, BufferedWriter writer) {
        this.proof_ = proof;
        this.justifier_ = justifier;
        this.writer_ = writer;
    }

    protected ProofPrinter(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier) {
        this(proof, justifier, new BufferedWriter(new OutputStreamWriter(System.out)));
    }

    public void printProof(C conclusion) throws IOException {
        this.process(conclusion);
        this.process();
        this.writer_.flush();
    }

    public static <C, I extends Inference<? extends C>, A> void print(Proof<? extends I> proof, InferenceJustifier<? super I, ? extends Set<? extends A>> justifier, C goal) throws IOException {
        ProofPrinter<C, I, A> pp = new ProofPrinter<C, I, A>(proof, justifier);
        pp.printProof(goal);
    }

    public static <C, I extends Inference<? extends C>> void print(Proof<? extends I> proof, C goal) throws IOException {
        ProofPrinter.print(proof, new BaseInferenceJustifier(Collections.emptyMap(), Collections.emptySet()), goal);
    }

    protected BufferedWriter getWriter() {
        return this.writer_;
    }

    protected void writeConclusion(C conclusion) throws IOException {
        this.writer_.write(conclusion.toString());
    }

    private boolean process(C conclusion) throws IOException {
        this.writePrefix();
        this.writeConclusion(conclusion);
        boolean newConclusion = this.printed_.add(conclusion);
        if (newConclusion) {
            this.inferenceStack_.push(this.proof_.getInferences(conclusion).iterator());
        } else {
            this.writer_.write(" *");
        }
        this.writer_.newLine();
        return newConclusion;
    }

    private void print(A just) throws IOException {
        this.writePrefix();
        this.writer_.write(just.toString());
        this.writer_.newLine();
    }

    private void process() throws IOException {
        Iterator<I> infIter;
        block0: while ((infIter = this.inferenceStack_.peek()) != null) {
            if (infIter.hasNext()) {
                Inference inf = (Inference)infIter.next();
                this.conclusionStack_.push(inf.getPremises().iterator());
                this.justificationStack_.push(this.justifier_.getJustification(inf).iterator());
            } else {
                this.inferenceStack_.pop();
            }
            Iterator<C> conclIter = this.conclusionStack_.peek();
            if (conclIter == null) {
                return;
            }
            while (conclIter.hasNext()) {
                if (!this.process(conclIter.next())) continue;
                continue block0;
            }
            Iterator<A> justIter = this.justificationStack_.peek();
            if (justIter == null) {
                return;
            }
            while (justIter.hasNext()) {
                this.print(justIter.next());
            }
            this.conclusionStack_.pop();
            this.justificationStack_.pop();
        }
        return;
    }

    private void writePrefix() throws IOException {
        Iterator<Iterator<I>> inferStackItr = this.inferenceStack_.descendingIterator();
        Iterator<Iterator<C>> conclStackItr = this.conclusionStack_.descendingIterator();
        Iterator<Iterator<A>> justStackItr = this.justificationStack_.descendingIterator();
        while (inferStackItr.hasNext()) {
            boolean hasNextPremise;
            Iterator<I> inferIter = inferStackItr.next();
            Iterator<C> conclIter = conclStackItr.next();
            Iterator<A> justIter = justStackItr.next();
            boolean bl = hasNextPremise = conclIter.hasNext() || justIter.hasNext();
            if (conclStackItr.hasNext() || justStackItr.hasNext()) {
                this.writer_.write(hasNextPremise ? "|  " : (inferIter.hasNext() ? ":  " : "   "));
                continue;
            }
            this.writer_.write(hasNextPremise ? "+- " : "\\- ");
        }
    }
}

