/*
 * Decompiled with CFR 0.152.
 */
package org.liveontologies.puli;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Proof;

public class ProofUnion<I extends Inference<?>>
implements Proof<I> {
    private final Iterable<? extends Proof<? extends I>> proofs_;

    public ProofUnion(Iterable<? extends Proof<? extends I>> proofs) {
        Preconditions.checkNotNull(proofs);
        this.proofs_ = proofs;
    }

    public ProofUnion(Proof<? extends I> ... proofs) {
        this(Arrays.asList(proofs));
    }

    @Override
    public Collection<? extends I> getInferences(Object conclusion) {
        ArrayList<? extends I> result = new ArrayList<I>();
        for (Proof<I> proof : this.proofs_) {
            Collection<? extends I> infs = proof.getInferences(conclusion);
            if (infs == null) continue;
            result.addAll(infs);
        }
        return result;
    }
}

